/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.backup;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.BackupEmbeddedIT;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.causalclustering.ClusterRule;

public class BackupCoreIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule(this.getClass()).withNumberOfCoreMembers(3).withNumberOfReadReplicas(0).withInstanceCoreParam(OnlineBackupSettings.online_backup_server, serverId -> ":" + (8000 + serverId));
    private Cluster cluster;
    private File backupsDir;

    @Before
    public void setup() throws Exception {
        this.backupsDir = this.clusterRule.testDirectory().cleanDirectory("backups");
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void makeSureBackupCanBePerformedFromAnyInstance() throws Throwable {
        for (CoreClusterMember db : this.cluster.coreMembers()) {
            DbRepresentation beforeChange = DbRepresentation.of((GraphDatabaseService)BackupCoreIT.createSomeData(this.cluster));
            File backupDir = new File(this.backupsDir, Integer.toString(db.serverId()));
            String[] args = BackupCoreIT.backupArguments(BackupCoreIT.backupAddress((GraphDatabaseFacade)db.database()), backupDir.getPath());
            Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])args));
            DbRepresentation afterChange = DbRepresentation.of((GraphDatabaseService)BackupCoreIT.createSomeData(this.cluster));
            DbRepresentation backupRepresentation = DbRepresentation.of((File)backupDir, (Config)BackupCoreIT.getConfig());
            Assert.assertEquals((Object)beforeChange, (Object)backupRepresentation);
            Assert.assertNotEquals((Object)backupRepresentation, (Object)afterChange);
        }
    }

    static CoreGraphDatabase createSomeData(Cluster cluster) throws Exception {
        return cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        }).database();
    }

    static String backupAddress(GraphDatabaseFacade db) {
        InetSocketAddress inetSocketAddress = ((AdvertisedSocketAddress)((Config)db.getDependencyResolver().resolveDependency(Config.class)).get(CausalClusteringSettings.transaction_advertised_address)).socketAddress();
        return inetSocketAddress.getHostName() + ":" + (inetSocketAddress.getPort() + 2000);
    }

    static String[] backupArguments(String from, String to) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-from");
        args.add(from);
        args.add("-to");
        args.add(to);
        return args.toArray(new String[args.size()]);
    }

    static Config getConfig() {
        return new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.record_format.name(), "standard"}));
    }
}

