/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.backup;

import java.io.File;
import java.util.LinkedList;

public class ArgsBuilder {
    private LinkedList<String> args = new LinkedList();

    public static ArgsBuilder args() {
        return new ArgsBuilder();
    }

    public ArgsBuilder homeDir(File homeDir) {
        this.args.add(String.format("--home-dir=%s", homeDir.getPath()));
        return this;
    }

    public ArgsBuilder database(String databaseName) {
        this.args.add(String.format("--database=%s", databaseName));
        return this;
    }

    public ArgsBuilder seed(String seed) {
        this.args.add(String.format("--cluster-seed=%s", seed));
        return this;
    }

    public ArgsBuilder config(File config) {
        this.args.add(String.format("--config=%s", config.getPath()));
        return this;
    }

    public ArgsBuilder from(File from) {
        this.args.add(String.format("--from=%s", from.getPath()));
        return this;
    }

    public ArgsBuilder force() {
        this.args.add("--force=true");
        return this;
    }

    public LinkedList<String> build() {
        return this.args;
    }

    public static String[] toArray(LinkedList<String> restoreOtherArgs) {
        return restoreOtherArgs.toArray(new String[restoreOtherArgs.size()]);
    }
}

