/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.test.rule.TestDirectory;

public class RejectCustomIOTest {
    private DiscoveryServiceFactory discovery = new SharedDiscoveryService();
    @Rule
    public TestDirectory storeDir = TestDirectory.testDirectory();

    @Test
    public void shouldFailToStartWithCustomIOConfigurationInCoreModeTest() throws Exception {
        try {
            Map extraParams = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_swapper.name(), "pageSwapperForTesting"});
            CoreClusterMember clusterMember = new CoreClusterMember(0, 3, Cluster.buildAddresses(Iterators.set((Object[])new Integer[]{0, 1, 2})), this.discovery, RecordFormatSelector.defaultFormat().toString(), this.storeDir.directory(), extraParams, Collections.emptyMap());
            clusterMember.start();
            Assert.fail((String)"Should not have created database with custom IO configuration in Core Mode.");
        }
        catch (RuntimeException ex) {
            Assert.assertEquals((Object)"Core cluster mode is not allowed with custom IO integrations", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldFailToStartWithCustomIOConfigurationInReadReplicaModeTest() throws Exception {
        try {
            SharedDiscoveryService discovery = new SharedDiscoveryService();
            Map extraParams = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_swapper.name(), "pageSwapperForTesting"});
            ReadReplica clusterMember = new ReadReplica(this.storeDir.directory(), 2, discovery, Cluster.buildAddresses(Iterators.set((Object[])new Integer[]{0, 1, 2})), extraParams, Collections.emptyMap(), RecordFormatSelector.defaultFormat().toString());
            clusterMember.start();
            Assert.fail((String)"Should not have created database with custom IO configuration in Read Replica Mode.");
        }
        catch (RuntimeException ex) {
            Assert.assertEquals((Object)"Read replica mode is not allowed with custom IO integrations", (Object)ex.getMessage());
        }
    }
}

