/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.readreplica;

import java.io.File;
import java.util.UUID;
import java.util.function.Function;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.readreplica.CommercialReadReplicaEditionModule;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;

public class CommercialReadReplicaGraphDatabase
extends ReadReplicaGraphDatabase {
    public CommercialReadReplicaGraphDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        this(storeDir, config, dependencies, (DiscoveryServiceFactory)new HazelcastDiscoveryServiceFactory(), new MemberId(UUID.randomUUID()));
    }

    public CommercialReadReplicaGraphDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, DiscoveryServiceFactory discoveryServiceFactory, MemberId memberId) {
        Function<PlatformModule, EditionModule> factory = platformModule -> new CommercialReadReplicaEditionModule((PlatformModule)platformModule, discoveryServiceFactory, memberId);
        new GraphDatabaseFacadeFactory(DatabaseInfo.READ_REPLICA, factory).initFacade(storeDir, config, dependencies, (GraphDatabaseFacade)this);
    }
}

