/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.causalclustering.discovery.SslHazelcastDiscoveryServiceFactory;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.ssl.SslResourceBuilder;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class SecureClusterIT {
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    private Cluster cluster;

    @After
    public void cleanup() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void shouldReplicateInSecureCluster() throws Exception {
        int keyId;
        File baseDir;
        File homeDir;
        String sslPolicyName = "cluster";
        SslPolicyConfig policyConfig = new SslPolicyConfig(sslPolicyName);
        Map coreParams = MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.ssl_policy.name(), sslPolicyName, policyConfig.base_directory.name(), "certificates/cluster"});
        Map readReplicaParams = MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.ssl_policy.name(), sslPolicyName, policyConfig.base_directory.name(), "certificates/cluster"});
        int noOfCoreMembers = 3;
        int noOfReadReplicas = 3;
        this.cluster = new Cluster(this.testDir.absolutePath(), noOfCoreMembers, noOfReadReplicas, (DiscoveryServiceFactory)new SslHazelcastDiscoveryServiceFactory(), coreParams, Collections.emptyMap(), readReplicaParams, Collections.emptyMap(), "standard", IpFamily.IPV4, false);
        for (CoreClusterMember core : this.cluster.coreMembers()) {
            homeDir = this.cluster.getCoreMemberById(core.serverId()).homeDir();
            baseDir = new File(homeDir, "certificates/cluster");
            this.fsRule.mkdirs(new File(baseDir, "trusted"));
            this.fsRule.mkdirs(new File(baseDir, "revoked"));
            keyId = core.serverId();
            SslResourceBuilder.caSignedKeyId((int)keyId).trustSignedByCA().install(baseDir);
        }
        for (ReadReplica replica : this.cluster.readReplicas()) {
            homeDir = this.cluster.getReadReplicaById(replica.serverId()).homeDir();
            baseDir = new File(homeDir, "certificates/cluster");
            this.fsRule.mkdirs(new File(baseDir, "trusted"));
            this.fsRule.mkdirs(new File(baseDir, "revoked"));
            keyId = replica.serverId() + noOfCoreMembers;
            SslResourceBuilder.caSignedKeyId((int)keyId).trustSignedByCA().install(baseDir);
        }
        this.cluster.start();
        CoreClusterMember leader = this.cluster.coreTx((db, tx) -> {
            Node node = db.createNode(new Label[]{Label.label((String)"boo")});
            node.setProperty("foobar", (Object)"baz_bat");
            tx.success();
        });
        Cluster.dataMatchesEventually((ClusterMember)leader, (Collection)this.cluster.coreMembers());
        Cluster.dataMatchesEventually((ClusterMember)leader, (Collection)this.cluster.readReplicas());
    }
}

