/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.impl.OnlineBackupCommandCcIT;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.discovery.SslHazelcastDiscoveryServiceFactory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.ssl.SslResourceBuilder;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;
import org.neo4j.util.TestHelpers;

public class EncryptedBackupIT {
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    private Cluster cluster;

    @After
    public void cleanup() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void backupsArePossibleFromEncryptedCluster() throws Exception {
        this.cluster = this.anEncryptedCluster();
        EncryptedBackupIT.installCryptographicObjectsToEachCore(this.cluster, (FileSystemRule)this.fsRule);
        this.cluster.start();
        File NEO4J_HOME = this.testDir.directory("NEO4J_HOME");
        String backupName = "encryptedBackup";
        File backupDir = this.testDir.directory("backup-dir");
        this.installCryptographicObjectsToBackupHome(backupDir, backupName, this.cluster.getDbWithRole(Role.LEADER).serverId());
        int exitCode = TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)NEO4J_HOME, (String[])new String[]{"--cc-report-dir=" + backupDir, "--backup-dir=" + backupDir, "--name=" + backupName, "--from=" + EncryptedBackupIT.backupAddress(this.cluster)});
        Assert.assertEquals((long)0L, (long)exitCode);
        EncryptedBackupIT.backupDataMatchesDatabase(this.cluster, backupDir, backupName);
        OnlineBackupCommandCcIT.createSomeData((Cluster)this.cluster);
        Cluster.dataMatchesEventually((ClusterMember)this.cluster.getDbWithRole(Role.LEADER), (Collection)this.cluster.coreMembers());
        exitCode = TestHelpers.runBackupToolFromOtherJvmToGetExitCode((File)NEO4J_HOME, (String[])new String[]{"--cc-report-dir=" + backupDir, "--backup-dir=" + backupDir, "--name=" + backupName, "--from=" + EncryptedBackupIT.backupAddress(this.cluster)});
        Assert.assertEquals((long)0L, (long)exitCode);
        EncryptedBackupIT.backupDataMatchesDatabase(this.cluster, backupDir, backupName);
    }

    private static String backupAddress(Cluster cluster) {
        return cluster.getDbWithRole(Role.LEADER).settingValue(CausalClusteringSettings.transaction_listen_address.name());
    }

    private void installCryptographicObjectsToBackupHome(File neo4J_home, String backupName, int keyId) throws IOException {
        File baseDir = new File(neo4J_home, backupName);
        EncryptedBackupIT.installSsl((FileSystemRule)this.fsRule, baseDir, keyId);
    }

    private Cluster anEncryptedCluster() {
        String sslPolicyName = "cluster";
        SslPolicyConfig policyConfig = new SslPolicyConfig(sslPolicyName);
        Map coreParams = MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.ssl_policy.name(), sslPolicyName, policyConfig.base_directory.name(), "certificates/cluster"});
        Map readReplicaParams = MapUtil.stringMap((String[])new String[]{CausalClusteringSettings.ssl_policy.name(), sslPolicyName, policyConfig.base_directory.name(), "certificates/cluster"});
        int noOfCoreMembers = 3;
        int noOfReadReplicas = 0;
        return new Cluster(this.testDir.absolutePath(), noOfCoreMembers, noOfReadReplicas, (DiscoveryServiceFactory)new SslHazelcastDiscoveryServiceFactory(), coreParams, Collections.emptyMap(), readReplicaParams, Collections.emptyMap(), "standard", IpFamily.IPV4, false);
    }

    private static void installCryptographicObjectsToEachCore(Cluster cluster, FileSystemRule fsRule) throws IOException {
        for (CoreClusterMember core : cluster.coreMembers()) {
            File homeDir = cluster.getCoreMemberById(core.serverId()).homeDir();
            File baseDir = new File(homeDir, "certificates/cluster");
            int keyId = core.serverId();
            EncryptedBackupIT.installSsl(fsRule, baseDir, keyId);
        }
    }

    private static void installSsl(FileSystemRule fsRule, File baseDir, int keyId) throws IOException {
        fsRule.mkdirs(new File(baseDir, "trusted"));
        fsRule.mkdirs(new File(baseDir, "revoked"));
        SslResourceBuilder.caSignedKeyId((int)keyId).trustSignedByCA().install(baseDir);
    }

    private static void backupDataMatchesDatabase(Cluster cluster, File backupDir, String backupName) {
        Assert.assertEquals((Object)DbRepresentation.of((GraphDatabaseService)OnlineBackupCommandCcIT.clusterDatabase((Cluster)cluster)), (Object)OnlineBackupCommandCcIT.getBackupDbRepresentation((String)backupName, (File)backupDir));
    }
}

