/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.request;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.bolt.v3.messaging.request.MessageMetadataParser;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class BeginMessage
implements RequestMessage {
    public static final byte SIGNATURE = 17;
    private final MapValue meta;
    private final Bookmark bookmark;
    private final Duration txTimeout;
    private final Map<String, Object> txMetadata;

    public BeginMessage() throws BoltIOException {
        this(VirtualValues.EMPTY_MAP);
    }

    public BeginMessage(MapValue meta) throws BoltIOException {
        this.meta = Objects.requireNonNull(meta);
        this.bookmark = Bookmark.fromParamsOrNull(meta);
        this.txTimeout = MessageMetadataParser.parseTransactionTimeout(meta);
        this.txMetadata = MessageMetadataParser.parseTransactionMetadata(meta);
    }

    public Bookmark bookmark() {
        return this.bookmark;
    }

    public Duration transactionTimeout() {
        return this.txTimeout;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeginMessage that = (BeginMessage)o;
        return Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(this.meta);
    }

    public String toString() {
        return "BEGIN " + this.meta;
    }

    public MapValue meta() {
        return this.meta;
    }

    public Map<String, Object> transactionMetadata() {
        return this.txMetadata;
    }
}

