/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.LinkedList;
import java.util.Map;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

class ExecutionPlanConverter {
    private ExecutionPlanConverter() {
    }

    public static MapValue convert(ExecutionPlanDescription plan) {
        boolean hasProfilerStatistics = plan.hasProfilerStatistics();
        int size = hasProfilerStatistics ? 9 : 4;
        MapValueBuilder out = new MapValueBuilder(size);
        out.add("operatorType", (AnyValue)Values.stringValue((String)plan.getName()));
        out.add("args", (AnyValue)ValueUtils.asMapValue((Map)plan.getArguments()));
        out.add("identifiers", (AnyValue)ValueUtils.asListValue((Iterable)plan.getIdentifiers()));
        out.add("children", (AnyValue)ExecutionPlanConverter.children(plan));
        if (hasProfilerStatistics) {
            ExecutionPlanDescription.ProfilerStatistics profile = plan.getProfilerStatistics();
            out.add("dbHits", (AnyValue)Values.longValue((long)profile.getDbHits()));
            out.add("pageCacheHits", (AnyValue)Values.longValue((long)profile.getPageCacheHits()));
            out.add("pageCacheMisses", (AnyValue)Values.longValue((long)profile.getPageCacheMisses()));
            out.add("pageCacheHitRatio", (AnyValue)Values.doubleValue((double)profile.getPageCacheHitRatio()));
            out.add("rows", (AnyValue)Values.longValue((long)profile.getRows()));
        }
        return out.build();
    }

    private static ListValue children(ExecutionPlanDescription plan) {
        LinkedList<MapValue> children = new LinkedList<MapValue>();
        for (ExecutionPlanDescription child : plan.getChildren()) {
            children.add(ExecutionPlanConverter.convert(child));
        }
        return VirtualValues.fromList(children);
    }
}

