/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.handler.ssl.SslContext;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.time.Clock;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BoltConnectionReadLimiter;
import org.neo4j.bolt.runtime.BoltSchedulerProvider;
import org.neo4j.bolt.runtime.BoltStateMachineFactory;
import org.neo4j.bolt.runtime.BoltStateMachineFactoryImpl;
import org.neo4j.bolt.runtime.CachedThreadPoolExecutorFactory;
import org.neo4j.bolt.runtime.DefaultBoltConnectionFactory;
import org.neo4j.bolt.runtime.ExecutorBoltSchedulerProvider;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.bolt.transport.BoltProtocolFactory;
import org.neo4j.bolt.transport.DefaultBoltProtocolFactory;
import org.neo4j.bolt.transport.Netty4LoggerFactory;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.SocketTransport;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.udc.UsageData;

public class BoltServer
extends LifecycleAdapter {
    private final DatabaseManager databaseManager;
    private final JobScheduler jobScheduler;
    private final ConnectorPortRegister connectorPortRegister;
    private final NetworkConnectionTracker connectionTracker;
    private final UsageData usageData;
    private final Config config;
    private final Clock clock;
    private final Monitors monitors;
    private final LogService logService;
    private final DependencyResolver dependencyResolver;
    private final LifeSupport life = new LifeSupport();

    public BoltServer(DatabaseManager databaseManager, JobScheduler jobScheduler, ConnectorPortRegister connectorPortRegister, NetworkConnectionTracker connectionTracker, UsageData usageData, Config config, Clock clock, Monitors monitors, LogService logService, DependencyResolver dependencyResolver) {
        this.databaseManager = databaseManager;
        this.jobScheduler = jobScheduler;
        this.connectorPortRegister = connectorPortRegister;
        this.connectionTracker = connectionTracker;
        this.usageData = usageData;
        this.config = config;
        this.clock = clock;
        this.monitors = monitors;
        this.logService = logService;
        this.dependencyResolver = dependencyResolver;
    }

    public void start() throws Throwable {
        Log log = this.logService.getInternalLog(BoltServer.class);
        Log userLog = this.logService.getUserLog(BoltServer.class);
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Netty4LoggerFactory(this.logService.getInternalLogProvider()));
        Authentication authentication = this.createAuthentication();
        TransportThrottleGroup throttleGroup = new TransportThrottleGroup(this.config, this.clock);
        BoltSchedulerProvider boltSchedulerProvider = (BoltSchedulerProvider)this.life.add((Lifecycle)new ExecutorBoltSchedulerProvider(this.config, new CachedThreadPoolExecutorFactory(log), this.jobScheduler, this.logService));
        BoltConnectionFactory boltConnectionFactory = this.createConnectionFactory(this.config, boltSchedulerProvider, throttleGroup, this.logService, this.clock);
        BoltStateMachineFactory boltStateMachineFactory = this.createBoltFactory(authentication, this.clock);
        BoltProtocolFactory boltProtocolFactory = this.createBoltProtocolFactory(boltConnectionFactory, boltStateMachineFactory);
        if (!this.config.enabledBoltConnectors().isEmpty() && !((Boolean)this.config.get(GraphDatabaseSettings.disconnected)).booleanValue()) {
            NettyServer server = new NettyServer(this.jobScheduler.threadFactory(Group.BOLT_NETWORK_IO), this.createConnectors(boltProtocolFactory, throttleGroup, log), this.connectorPortRegister, userLog);
            this.life.add((Lifecycle)server);
            log.info("Bolt server loaded");
        }
        this.life.start();
    }

    public void stop() throws Throwable {
        this.life.shutdown();
    }

    private BoltConnectionFactory createConnectionFactory(Config config, BoltSchedulerProvider schedulerProvider, TransportThrottleGroup throttleGroup, LogService logService, Clock clock) {
        return new DefaultBoltConnectionFactory(schedulerProvider, throttleGroup, logService, clock, new BoltConnectionReadLimiter(logService.getInternalLog(BoltConnectionReadLimiter.class), (Integer)config.get(GraphDatabaseSettings.bolt_inbound_message_throttle_low_water_mark), (Integer)config.get(GraphDatabaseSettings.bolt_inbound_message_throttle_high_water_mark)), this.monitors);
    }

    private Map<BoltConnector, NettyServer.ProtocolInitializer> createConnectors(BoltProtocolFactory boltProtocolFactory, TransportThrottleGroup throttleGroup, Log log) {
        return this.config.enabledBoltConnectors().stream().collect(Collectors.toMap(Function.identity(), connector -> this.createProtocolInitializer((BoltConnector)connector, boltProtocolFactory, throttleGroup, log)));
    }

    private NettyServer.ProtocolInitializer createProtocolInitializer(BoltConnector connector, BoltProtocolFactory boltProtocolFactory, TransportThrottleGroup throttleGroup, Log log) {
        SslContext sslCtx;
        boolean requireEncryption;
        BoltConnector.EncryptionLevel encryptionLevel = (BoltConnector.EncryptionLevel)this.config.get(connector.encryption_level);
        SslPolicyLoader sslPolicyLoader = (SslPolicyLoader)this.dependencyResolver.resolveDependency(SslPolicyLoader.class);
        switch (encryptionLevel) {
            case REQUIRED: {
                requireEncryption = true;
                sslCtx = BoltServer.createSslContext(sslPolicyLoader, this.config);
                break;
            }
            case OPTIONAL: {
                requireEncryption = false;
                sslCtx = BoltServer.createSslContext(sslPolicyLoader, this.config);
                break;
            }
            case DISABLED: {
                requireEncryption = false;
                sslCtx = null;
                break;
            }
            default: {
                log.warn("Unhandled encryption level %s - assuming DISABLED.", new Object[]{encryptionLevel.name()});
                requireEncryption = false;
                sslCtx = null;
            }
        }
        ListenSocketAddress listenAddress = (ListenSocketAddress)this.config.get(connector.listen_address);
        return new SocketTransport(connector.key(), listenAddress, sslCtx, requireEncryption, this.logService.getInternalLogProvider(), throttleGroup, boltProtocolFactory, this.connectionTracker);
    }

    private static SslContext createSslContext(SslPolicyLoader sslPolicyFactory, Config config) {
        try {
            String policyName = (String)config.get(GraphDatabaseSettings.bolt_ssl_policy);
            if (policyName == null) {
                throw new IllegalArgumentException("No SSL policy has been configured for Bolt server");
            }
            return sslPolicyFactory.getPolicy(policyName).nettyServerContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize SSL encryption support, which is required to start this connector. Error was: " + e.getMessage(), e);
        }
    }

    private Authentication createAuthentication() {
        return new BasicAuthentication((AuthManager)this.dependencyResolver.resolveDependency(AuthManager.class), (UserManagerSupplier)this.dependencyResolver.resolveDependency(UserManagerSupplier.class));
    }

    private BoltProtocolFactory createBoltProtocolFactory(BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory) {
        return new DefaultBoltProtocolFactory(connectionFactory, stateMachineFactory, this.logService);
    }

    private BoltStateMachineFactory createBoltFactory(Authentication authentication, Clock clock) {
        return new BoltStateMachineFactoryImpl(this.databaseManager, this.usageData, authentication, clock, this.config, this.logService);
    }
}

