/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.runtime;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.MutableConnectionState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.runtime.ConnectedState;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Values;

class ConnectedStateTest {
    ConnectedStateTest() {
    }

    @Test
    void shouldAddServerVersionMetadataOnHelloMessage() throws Exception {
        Map meta = MapUtil.map((Object[])new Object[]{"user_agent", "3.0", "principal", "neo4j", "credentials", "password"});
        HelloMessage helloMessage = new HelloMessage(meta);
        ConnectedState state = new ConnectedState();
        BoltStateMachineState readyState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
        StateMachineContext context = (StateMachineContext)Mockito.mock(StateMachineContext.class);
        BoltStateMachineSPI boltSpi = (BoltStateMachineSPI)Mockito.mock(BoltStateMachineSPI.class, (Answer)Mockito.RETURNS_MOCKS);
        MutableConnectionState connectionState = new MutableConnectionState();
        state.setReadyState(readyState);
        Mockito.when((Object)context.boltSpi()).thenReturn((Object)boltSpi);
        Mockito.when((Object)context.connectionState()).thenReturn((Object)connectionState);
        Mockito.when((Object)boltSpi.version()).thenReturn((Object)"42.42.42");
        MutableConnectionState connectionStateMock = (MutableConnectionState)Mockito.mock(MutableConnectionState.class);
        Mockito.when((Object)context.connectionState()).thenReturn((Object)connectionStateMock);
        Mockito.when((Object)context.connectionId()).thenReturn((Object)"connection-uuid");
        Mockito.when((Object)boltSpi.authenticate(meta)).thenReturn((Object)AuthenticationResult.AUTH_DISABLED);
        BoltStateMachineState newState = state.process((RequestMessage)helloMessage, context);
        Assertions.assertEquals((Object)readyState, (Object)newState);
        ((MutableConnectionState)Mockito.verify((Object)connectionStateMock)).onMetadata("server", (AnyValue)Values.stringValue((String)"42.42.42"));
        ((MutableConnectionState)Mockito.verify((Object)connectionStateMock)).onMetadata((String)ArgumentMatchers.eq((Object)"connection_id"), (AnyValue)ArgumentMatchers.any(StringValue.class));
    }
}

