/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.request;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.v3.messaging.request.MessageMetadataParser;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class MessageMetadataParserTest {
    MessageMetadataParserTest() {
    }

    @Test
    void shouldAllowNoTransactionTimeout() throws Exception {
        Assertions.assertNull((Object)MessageMetadataParser.parseTransactionTimeout((MapValue)VirtualValues.emptyMap()));
    }

    @Test
    void shouldAllowNoTransactionMetadata() throws Exception {
        Assertions.assertNull((Object)MessageMetadataParser.parseTransactionMetadata((MapValue)VirtualValues.emptyMap()));
    }

    @Test
    void shouldThrowForIncorrectTransactionTimeout() {
        BoltIOException e = (BoltIOException)Assertions.assertThrows(BoltIOException.class, () -> MessageMetadataParser.parseTransactionTimeout((MapValue)ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"tx_timeout", "15 minutes"}))));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldThrowForIncorrectTransactionMetadata() {
        BoltIOException e = (BoltIOException)Assertions.assertThrows(BoltIOException.class, () -> MessageMetadataParser.parseTransactionMetadata((MapValue)ValueUtils.asMapValue((Map)MapUtil.map((Object[])new Object[]{"tx_metadata", "{key1: 'value1', key2: 'value2'}"}))));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }
}

