/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.request;

import java.time.Duration;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.virtual.MapValue;

class BeginMessageTest {
    BeginMessageTest() {
    }

    @Test
    void shouldParseEmptyTransactionMetadataCorrectly() throws Throwable {
        BeginMessage message = new BeginMessage();
        Assertions.assertNull((Object)message.transactionMetadata());
    }

    @Test
    void shouldThrowExceptionIfFailedToParseTransactionMetadataCorrectly() throws Throwable {
        Map msgMetadata = MapUtil.map((Object[])new Object[]{"tx_metadata", "invalid value type"});
        MapValue meta = ValueUtils.asMapValue((Map)msgMetadata);
        BoltIOException exception = (BoltIOException)Assertions.assertThrows(BoltIOException.class, () -> new BeginMessage(meta));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.startsWith((String)"Expecting transaction metadata value to be a Map value"));
    }

    @Test
    void shouldParseTransactionMetadataCorrectly() throws Throwable {
        Map txMetadata = MapUtil.map((Object[])new Object[]{"creation-time", Duration.ofMillis(4321L)});
        Map msgMetadata = MapUtil.map((Object[])new Object[]{"tx_metadata", txMetadata});
        MapValue meta = ValueUtils.asMapValue((Map)msgMetadata);
        BeginMessage beginMessage = new BeginMessage(meta);
        MatcherAssert.assertThat((Object)beginMessage.transactionMetadata().toString(), (Matcher)Matchers.equalTo((Object)txMetadata.toString()));
    }

    @Test
    void shouldThrowExceptionIfFailedToParseTransactionTimeoutCorrectly() throws Throwable {
        Map msgMetadata = MapUtil.map((Object[])new Object[]{"tx_timeout", "invalid value type"});
        MapValue meta = ValueUtils.asMapValue((Map)msgMetadata);
        BoltIOException exception = (BoltIOException)Assertions.assertThrows(BoltIOException.class, () -> new BeginMessage(meta));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.startsWith((String)"Expecting transaction timeout value to be a Long value"));
    }

    @Test
    void shouldParseTransactionTimeoutCorrectly() throws Throwable {
        Map msgMetadata = MapUtil.map((Object[])new Object[]{"tx_timeout", 123456L});
        MapValue meta = ValueUtils.asMapValue((Map)msgMetadata);
        BeginMessage beginMessage = new BeginMessage(meta);
        MatcherAssert.assertThat((Object)beginMessage.transactionTimeout().toMillis(), (Matcher)Matchers.equalTo((Object)123456L));
    }
}

