/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.decoder;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.security.auth.AuthTokenDecoderTest;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackedInputArray;
import org.neo4j.bolt.v3.messaging.BoltProtocolV3ComponentFactory;
import org.neo4j.bolt.v3.messaging.decoder.HelloMessageDecoder;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.AuthTokenUtil;

class HelloMessageDecoderTest
extends AuthTokenDecoderTest {
    private final BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
    private final RequestMessageDecoder decoder = new HelloMessageDecoder(this.responseHandler);

    HelloMessageDecoderTest() {
    }

    @Test
    void shouldReturnCorrectSignature() {
        Assertions.assertEquals((int)1, (int)this.decoder.signature());
    }

    @Test
    void shouldReturnConnectResponseHandler() {
        Assertions.assertEquals((Object)this.responseHandler, (Object)this.decoder.responseHandler());
    }

    @Test
    void shouldDecodeHelloMessage() throws Exception {
        HelloMessage originalMessage = new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", "My Driver", "user", "neo4j", "password", "secret"}));
        HelloMessageDecoderTest.assertOriginalMessageEqualsToDecoded((RequestMessage)originalMessage, this.decoder);
    }

    static void assertOriginalMessageEqualsToDecoded(RequestMessage originalMessage, RequestMessageDecoder decoder) throws Exception {
        Neo4jPack neo4jPack = BoltProtocolV3ComponentFactory.newNeo4jPack();
        PackedInputArray input = new PackedInputArray(BoltProtocolV3ComponentFactory.encode(neo4jPack, originalMessage));
        Neo4jPack.Unpacker unpacker = neo4jPack.newUnpacker((PackInput)input);
        unpacker.unpackStructHeader();
        unpacker.unpackStructSignature();
        RequestMessage deserializedMessage = decoder.decode(unpacker);
        Assertions.assertEquals((Object)originalMessage, (Object)deserializedMessage);
    }

    @Override
    protected void testShouldDecodeAuthToken(Map<String, Object> authToken) throws Exception {
        Neo4jPack neo4jPack = BoltProtocolV3ComponentFactory.newNeo4jPack();
        authToken.put("user_agent", "My Driver");
        HelloMessage originalMessage = new HelloMessage(authToken);
        PackedInputArray input = new PackedInputArray(BoltProtocolV3ComponentFactory.encode(neo4jPack, new RequestMessage[]{originalMessage}));
        Neo4jPack.Unpacker unpacker = neo4jPack.newUnpacker((PackInput)input);
        unpacker.unpackStructHeader();
        unpacker.unpackStructSignature();
        RequestMessage deserializedMessage = this.decoder.decode(unpacker);
        HelloMessageDecoderTest.assertHelloMessageMatches(originalMessage, deserializedMessage);
    }

    @Override
    protected void testShouldFailToDecodeAuthToken(Map<String, Object> authToken, String expectedErrorMessage) throws Exception {
        Neo4jPack neo4jPack = BoltProtocolV3ComponentFactory.newNeo4jPack();
        authToken.put("user_agent", "My Driver");
        HelloMessage originalMessage = new HelloMessage(authToken);
        PackedInputArray input = new PackedInputArray(BoltProtocolV3ComponentFactory.encode(neo4jPack, new RequestMessage[]{originalMessage}));
        Neo4jPack.Unpacker unpacker = neo4jPack.newUnpacker((PackInput)input);
        unpacker.unpackStructHeader();
        unpacker.unpackStructSignature();
        try {
            this.decoder.decode(unpacker);
            Assertions.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertEquals((Object)e.getMessage(), (Object)expectedErrorMessage);
        }
    }

    private static void assertHelloMessageMatches(HelloMessage expected, RequestMessage actual) {
        AuthTokenUtil.assertAuthTokenMatches((Map)expected.meta(), (Map)((HelloMessage)actual).meta());
    }
}

