/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.decoder;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v3.messaging.decoder.GoodbyeMessageDecoder;
import org.neo4j.bolt.v3.messaging.decoder.HelloMessageDecoderTest;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;

class GoodbyeMessageDecoderTest {
    private final BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
    private final BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
    private final RequestMessageDecoder decoder = new GoodbyeMessageDecoder(this.connection, this.responseHandler);

    GoodbyeMessageDecoderTest() {
    }

    @Test
    void shouldReturnCorrectSignature() {
        Assertions.assertEquals((int)2, (int)this.decoder.signature());
    }

    @Test
    void shouldReturnConnectResponseHandler() {
        Assertions.assertEquals((Object)this.responseHandler, (Object)this.decoder.responseHandler());
    }

    @Test
    void shouldDecodeGoodbyeMessage() throws Exception {
        HelloMessageDecoderTest.assertOriginalMessageEqualsToDecoded((RequestMessage)GoodbyeMessage.GOODBYE_MESSAGE, this.decoder);
        ((BoltConnection)Mockito.verify((Object)this.connection)).stop();
    }
}

