/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.decoder;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v3.messaging.decoder.BeginMessageDecoder;
import org.neo4j.bolt.v3.messaging.decoder.HelloMessageDecoderTest;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class BeginMessageDecoderTest {
    private final BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
    private final RequestMessageDecoder decoder = new BeginMessageDecoder(this.responseHandler);

    BeginMessageDecoderTest() {
    }

    @Test
    void shouldReturnCorrectSignature() {
        Assertions.assertEquals((int)17, (int)this.decoder.signature());
    }

    @Test
    void shouldReturnConnectResponseHandler() {
        Assertions.assertEquals((Object)this.responseHandler, (Object)this.decoder.responseHandler());
    }

    @Test
    void shouldDecodeBeginMessage() throws Exception {
        BeginMessage originalMessage = new BeginMessage(VirtualValues.map((String[])new String[]{"tx_metadata", "tx_timeout"}, (AnyValue[])new AnyValue[]{MapValue.EMPTY, Values.longValue((long)10000L)}));
        HelloMessageDecoderTest.assertOriginalMessageEqualsToDecoded((RequestMessage)originalMessage, this.decoder);
    }
}

