/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageWriter;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;

public class BoltRequestMessageWriterV3
extends BoltRequestMessageWriter {
    public BoltRequestMessageWriterV3(Neo4jPack.Packer packer) {
        super(packer);
    }

    @Override
    public BoltRequestMessageWriter write(RequestMessage message) throws IOException {
        if (message instanceof HelloMessage) {
            this.writeHello((HelloMessage)message);
        } else if (message instanceof BeginMessage) {
            this.writeBegin((BeginMessage)message);
        } else if (message instanceof CommitMessage) {
            this.writeCommit();
        } else if (message instanceof RollbackMessage) {
            this.writeRollback();
        } else if (message instanceof RunMessage) {
            this.writeRun((RunMessage)message);
        } else {
            super.write(message);
        }
        return this;
    }

    private void writeRun(RunMessage message) {
        try {
            this.packer.packStructHeader(0, (byte)16);
            this.packer.pack(message.statement());
            this.packer.pack((AnyValue)message.params());
            this.packer.pack((AnyValue)message.meta());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeRollback() {
        this.writeSignatureOnlyMessage((byte)19);
    }

    private void writeCommit() {
        this.writeSignatureOnlyMessage((byte)18);
    }

    private void writeBegin(BeginMessage message) {
        try {
            this.packer.packStructHeader(0, (byte)17);
            this.packer.pack((AnyValue)message.meta());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeSignatureOnlyMessage(byte signature) {
        try {
            this.packer.packStructHeader(0, signature);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeHello(HelloMessage message) {
        try {
            this.packer.packStructHeader(0, (byte)1);
            this.packer.pack((AnyValue)ValueUtils.asMapValue((Map)message.meta()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

