/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging;

import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackedInputArray;
import org.neo4j.bolt.v3.messaging.BoltProtocolV3ComponentFactory;
import org.neo4j.bolt.v3.messaging.request.BeginMessage;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.HelloMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.values.virtual.VirtualValues;

class BoltRequestMessageReaderV3Test {
    BoltRequestMessageReaderV3Test() {
    }

    @ParameterizedTest
    @MethodSource(value={"boltV3Messages"})
    void shouldDecodeV3Messages(RequestMessage message) throws Exception {
        BoltRequestMessageReaderV3Test.testMessageDecoding(message);
    }

    @ParameterizedTest
    @MethodSource(value={"boltV3UnsupportedMessages"})
    void shouldNotDecodeUnsupportedMessages(RequestMessage message) throws Exception {
        Assertions.assertThrows(Exception.class, () -> BoltRequestMessageReaderV3Test.testMessageDecoding(message));
    }

    private static void testMessageDecoding(RequestMessage message) throws Exception {
        Neo4jPack neo4jPack = BoltProtocolV3ComponentFactory.newNeo4jPack();
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        BoltRequestMessageReader reader = BoltProtocolV3ComponentFactory.requestMessageReader(stateMachine);
        PackedInputArray input = new PackedInputArray(BoltProtocolV3ComponentFactory.encode(neo4jPack, message));
        Neo4jPack.Unpacker unpacker = neo4jPack.newUnpacker((PackInput)input);
        reader.read(unpacker);
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).process((RequestMessage)ArgumentMatchers.eq((Object)message), (BoltResponseHandler)ArgumentMatchers.any());
    }

    private static Stream<RequestMessage> boltV3Messages() throws BoltIOException {
        return Stream.of(new HelloMessage(MapUtil.map((Object[])new Object[]{"user_agent", "My driver", "one", 1L, "two", 2L})), new RunMessage("RETURN 1", VirtualValues.EMPTY_MAP, VirtualValues.EMPTY_MAP), DiscardAllMessage.INSTANCE, PullAllMessage.INSTANCE, new BeginMessage(), CommitMessage.COMMIT_MESSAGE, RollbackMessage.ROLLBACK_MESSAGE, ResetMessage.INSTANCE);
    }

    private static Stream<RequestMessage> boltV3UnsupportedMessages() {
        return Stream.of(new InitMessage("My driver", MapUtil.map((Object[])new Object[]{"one", 1L, "two", 2L})), AckFailureMessage.INSTANCE, new org.neo4j.bolt.v1.messaging.request.RunMessage("RETURN 1"));
    }
}

