/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging;

import java.io.IOException;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.ResponseMessage;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.SynchronousBoltConnection;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageWriter;
import org.neo4j.bolt.v1.messaging.RecordingByteChannel;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.bolt.v3.messaging.BoltRequestMessageReaderV3;
import org.neo4j.bolt.v3.messaging.BoltRequestMessageWriterV3;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;

public class BoltProtocolV3ComponentFactory {
    public static Neo4jPack newNeo4jPack() {
        return new Neo4jPackV2();
    }

    public static BoltRequestMessageWriter requestMessageWriter(Neo4jPack.Packer packer) {
        return new BoltRequestMessageWriterV3(packer);
    }

    public static BoltRequestMessageReader requestMessageReader(BoltStateMachine stateMachine) {
        return new BoltRequestMessageReaderV3((BoltConnection)new SynchronousBoltConnection(stateMachine), (BoltResponseMessageWriter)Mockito.mock(BoltResponseMessageWriter.class), (LogService)NullLogService.getInstance());
    }

    public static byte[] encode(Neo4jPack neo4jPack, RequestMessage ... messages) throws IOException {
        RecordingByteChannel rawData = new RecordingByteChannel();
        Neo4jPack.Packer packer = neo4jPack.newPacker((PackOutput)new BufferedChannelOutput(rawData));
        BoltRequestMessageWriter writer = BoltProtocolV3ComponentFactory.requestMessageWriter(packer);
        for (RequestMessage message : messages) {
            writer.write(message);
        }
        writer.flush();
        return rawData.getBytes();
    }

    public static TransportTestUtil.MessageEncoder newMessageEncoder() {
        return new TransportTestUtil.MessageEncoder(){

            @Override
            public byte[] encode(Neo4jPack neo4jPack, RequestMessage ... messages) throws IOException {
                return BoltProtocolV3ComponentFactory.encode(neo4jPack, messages);
            }

            @Override
            public byte[] encode(Neo4jPack neo4jPack, ResponseMessage ... messages) throws IOException {
                return MessageMatchers.serialize(neo4jPack, messages);
            }
        };
    }
}

