/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltStateMachineFactory;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.bolt.v3.BoltProtocolV3;
import org.neo4j.bolt.v3.messaging.BoltRequestMessageReaderV3;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;

class BoltProtocolV3Test {
    BoltProtocolV3Test() {
    }

    @Test
    void shouldCreatePackForBoltV3() throws Throwable {
        BoltProtocolV3 protocolV3 = new BoltProtocolV3((BoltChannel)Mockito.mock(BoltChannel.class), (ch, st) -> (BoltConnection)Mockito.mock(BoltConnection.class), (BoltStateMachineFactory)Mockito.mock(BoltStateMachineFactory.class), (LogService)NullLogService.getInstance());
        MatcherAssert.assertThat((Object)protocolV3.createPack(), (Matcher)CoreMatchers.instanceOf(Neo4jPackV2.class));
    }

    @Test
    void shouldVersionReturnBoltV3() throws Throwable {
        BoltProtocolV3 protocolV3 = new BoltProtocolV3((BoltChannel)Mockito.mock(BoltChannel.class), (ch, st) -> (BoltConnection)Mockito.mock(BoltConnection.class), (BoltStateMachineFactory)Mockito.mock(BoltStateMachineFactory.class), (LogService)NullLogService.getInstance());
        MatcherAssert.assertThat((Object)protocolV3.version(), (Matcher)CoreMatchers.equalTo((Object)3L));
    }

    @Test
    void shouldCreateMessageReaderForBoltV3() throws Throwable {
        BoltProtocolV3 protocolV3 = new BoltProtocolV3((BoltChannel)Mockito.mock(BoltChannel.class), (ch, st) -> (BoltConnection)Mockito.mock(BoltConnection.class), (BoltStateMachineFactory)Mockito.mock(BoltStateMachineFactory.class), (LogService)NullLogService.getInstance());
        MatcherAssert.assertThat((Object)protocolV3.createMessageReader((BoltChannel)Mockito.mock(BoltChannel.class), (Neo4jPack)Mockito.mock(Neo4jPack.class), (BoltConnection)Mockito.mock(BoltConnection.class), (LogService)NullLogService.getInstance()), (Matcher)CoreMatchers.instanceOf(BoltRequestMessageReaderV3.class));
    }
}

