/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.socket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.embedded.EmbeddedChannel;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.SynchronousBoltConnection;
import org.neo4j.bolt.v1.BoltProtocolV1;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageWriter;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.RecordingByteChannel;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.transport.socket.Chunker;
import org.neo4j.bolt.v2.messaging.Neo4jPackV2;
import org.neo4j.kernel.impl.util.HexPrinter;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.values.virtual.VirtualValues;

@RunWith(value=Parameterized.class)
public class FragmentedMessageDeliveryTest {
    private EmbeddedChannel channel;
    private int chunkSize = 16;
    private RequestMessage[] messages = new RequestMessage[]{new RunMessage("Mj\u00f6lnir")};
    @Parameterized.Parameter
    public Neo4jPack neo4jPack;

    @Parameterized.Parameters(name="{0}")
    public static List<Neo4jPack> parameters() {
        return Arrays.asList(new Neo4jPackV1(), new Neo4jPackV2());
    }

    @After
    public void cleanup() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
        }
    }

    @Test
    public void testFragmentedMessageDelivery() throws Throwable {
        byte[] unfragmented = this.serialize(this.chunkSize, this.messages);
        int n = unfragmented.length;
        for (int i = 1; i < n - 1; ++i) {
            for (int j = 1; j < n - i; ++j) {
                this.testPermutation(unfragmented, i, j, n - i - j);
            }
        }
    }

    private void testPermutation(byte[] unfragmented, int ... sizes) throws Exception {
        int pos = 0;
        ByteBuf[] fragments = new ByteBuf[sizes.length];
        for (int i = 0; i < sizes.length; ++i) {
            fragments[i] = Unpooled.wrappedBuffer((byte[])unfragmented, (int)pos, (int)sizes[i]);
            pos += sizes[i];
        }
        this.testPermutation(unfragmented, fragments);
    }

    private void testPermutation(byte[] unfragmented, ByteBuf[] fragments) throws Exception {
        this.channel = new EmbeddedChannel();
        BoltChannel boltChannel = FragmentedMessageDeliveryTest.newBoltChannel(this.channel);
        BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        SynchronousBoltConnection boltConnection = new SynchronousBoltConnection(machine);
        NullLogService logging = NullLogService.getInstance();
        BoltProtocolV1 boltProtocol = new BoltProtocolV1(boltChannel, (ch, s) -> boltConnection, (v, ch) -> machine, (LogService)logging);
        boltProtocol.install();
        for (ByteBuf fragment : fragments) {
            this.channel.writeInbound(new Object[]{fragment.readerIndex(0).retain()});
        }
        try {
            RunMessage run = new RunMessage("Mj\u00f6lnir", VirtualValues.EMPTY_MAP);
            ((BoltStateMachine)Mockito.verify((Object)machine)).process((RequestMessage)ArgumentMatchers.eq((Object)run), (BoltResponseHandler)ArgumentMatchers.any(BoltResponseHandler.class));
        }
        catch (AssertionError e) {
            throw new AssertionError("Failed to handle fragmented delivery.\nMessages: " + Arrays.toString(this.messages) + "\nChunk size: " + this.chunkSize + "\nSerialized data delivered in fragments: " + this.describeFragments(fragments) + "\nUnfragmented data: " + HexPrinter.hex((byte[])unfragmented) + "\n", (Throwable)((Object)e));
        }
    }

    private String describeFragments(ByteBuf[] fragments) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fragments.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fragments[i].capacity());
        }
        return sb.toString();
    }

    private byte[] serialize(int chunkSize, RequestMessage ... msgs) throws IOException {
        byte[][] serialized = new byte[msgs.length][];
        for (int i = 0; i < msgs.length; ++i) {
            RecordingByteChannel channel = new RecordingByteChannel();
            BoltRequestMessageWriter writer = new BoltRequestMessageWriter(new Neo4jPackV1().newPacker((PackOutput)new BufferedChannelOutput(channel)));
            writer.write(msgs[i]).flush();
            serialized[i] = channel.getBytes();
        }
        return Chunker.chunk(chunkSize, serialized);
    }

    private static BoltChannel newBoltChannel(EmbeddedChannel rawChannel) {
        BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
        Mockito.when((Object)boltChannel.rawChannel()).thenReturn((Object)rawChannel);
        return boltChannel;
    }
}

