/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport.integration;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.SeverityLevel;

public class TestNotification
implements Notification {
    private final String code;
    private final String title;
    private final String description;
    private final SeverityLevel severityLevel;
    private final InputPosition position;

    public TestNotification(String code, String title, String description, SeverityLevel severityLevel, InputPosition position) {
        this.code = code;
        this.title = title;
        this.description = description;
        this.severityLevel = severityLevel;
        this.position = position != null ? position : InputPosition.empty;
    }

    public static Notification fromMap(Map<String, Object> notification) {
        MatcherAssert.assertThat(notification, (Matcher)Matchers.hasKey((Object)"code"));
        MatcherAssert.assertThat(notification, (Matcher)Matchers.hasKey((Object)"title"));
        MatcherAssert.assertThat(notification, (Matcher)Matchers.hasKey((Object)"description"));
        MatcherAssert.assertThat(notification, (Matcher)Matchers.hasKey((Object)"severity"));
        InputPosition position = null;
        if (notification.containsKey("position")) {
            Map pos = (Map)notification.get("position");
            MatcherAssert.assertThat((Object)pos, (Matcher)Matchers.hasKey((Object)"offset"));
            MatcherAssert.assertThat((Object)pos, (Matcher)Matchers.hasKey((Object)"line"));
            MatcherAssert.assertThat((Object)pos, (Matcher)Matchers.hasKey((Object)"column"));
            position = new InputPosition(((Long)pos.get("offset")).intValue(), ((Long)pos.get("line")).intValue(), ((Long)pos.get("column")).intValue());
        }
        return new TestNotification((String)notification.get("code"), (String)notification.get("title"), (String)notification.get("description"), SeverityLevel.valueOf((String)((String)notification.get("severity"))), position);
    }

    public String getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public SeverityLevel getSeverity() {
        return this.severityLevel;
    }

    public InputPosition getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestNotification that = (TestNotification)o;
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.severityLevel != that.severityLevel) {
            return false;
        }
        return this.position != null ? this.position.equals((Object)that.position) : that.position == null;
    }

    public int hashCode() {
        int result = this.code != null ? this.code.hashCode() : 0;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.severityLevel != null ? this.severityLevel.hashCode() : 0);
        result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
        return result;
    }
}

