/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.helpers.PortBindException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class NettyServerTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldGivePortConflictErrorWithPortNumberInIt() throws Throwable {
        int port = 16000;
        try (ServerSocketChannel ignore = ServerSocketChannel.open().bind(new InetSocketAddress("localhost", port));){
            ListenSocketAddress address = new ListenSocketAddress("localhost", port);
            this.exception.expect(PortBindException.class);
            Map initializersMap = MapUtil.genericMap((Object[])new Object[]{new BoltConnector("test"), this.protocolOnAddress(address)});
            new NettyServer((ThreadFactory)new NamedThreadFactory("mythreads"), initializersMap, new ConnectorPortRegister(), (Log)NullLog.getInstance()).start();
        }
    }

    private NettyServer.ProtocolInitializer protocolOnAddress(final ListenSocketAddress address) {
        return new NettyServer.ProtocolInitializer(){

            public ChannelInitializer<Channel> channelInitializer() {
                return new ChannelInitializer<Channel>(){

                    public void initChannel(Channel ch) {
                    }
                };
            }

            public ListenSocketAddress address() {
                return address;
            }
        };
    }
}

