/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.spi;

import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.NumberValue;

public class StreamMatchers {
    private StreamMatchers() {
    }

    public static Matcher<AnyValue> greaterThanOrEqualTo(final long input) {
        return new TypeSafeMatcher<AnyValue>(){

            public void describeTo(Description description) {
                description.appendText("Value = " + input);
            }

            protected boolean matchesSafely(AnyValue value) {
                return value instanceof NumberValue && ((NumberValue)value).longValue() >= input;
            }
        };
    }

    public static Matcher<QueryResult.Record> eqRecord(final Matcher<?> ... expectedFieldValues) {
        return new TypeSafeMatcher<QueryResult.Record>(){

            protected boolean matchesSafely(QueryResult.Record item) {
                if (expectedFieldValues.length != item.fields().length) {
                    return false;
                }
                for (int i = 0; i < item.fields().length; ++i) {
                    if (expectedFieldValues[i].matches((Object)item.fields()[i])) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("Record[").appendList(", fields=[", ",", "]", Arrays.asList(expectedFieldValues));
            }
        };
    }
}

