/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.bookmarking;

import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.bolt.v1.runtime.bookmarking.BookmarkFormatException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

class BookmarkTest {
    BookmarkTest() {
    }

    @Test
    void shouldFormatAndParseSingleBookmarkContainingTransactionId() throws Exception {
        long txId = 1234L;
        MapValue params = BookmarkTest.singletonMap("bookmark", new Bookmark(txId).toString());
        Bookmark bookmark = Bookmark.fromParamsOrNull((MapValue)params);
        Assertions.assertEquals((long)txId, (long)bookmark.txId());
    }

    @Test
    void shouldFormatAndParseMultipleBookmarksContainingTransactionId() throws Exception {
        long txId1 = 1234L;
        long txId2 = 12345L;
        MapValue params = BookmarkTest.singletonMap("bookmarks", Arrays.asList(new Bookmark(txId1).toString(), new Bookmark(txId2).toString()));
        Bookmark bookmark = Bookmark.fromParamsOrNull((MapValue)params);
        Assertions.assertEquals((long)txId2, (long)bookmark.txId());
    }

    @Test
    void shouldParseAndFormatSingleBookmarkContainingTransactionId() throws Exception {
        String expected = "neo4j:bookmark:v1:tx1234";
        MapValue params = BookmarkTest.singletonMap("bookmark", expected);
        String actual = new Bookmark(Bookmark.fromParamsOrNull((MapValue)params).txId()).toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    void shouldParseAndFormatMultipleBookmarkContainingTransactionId() throws Exception {
        String txId1 = "neo4j:bookmark:v1:tx1234";
        String txId2 = "neo4j:bookmark:v1:tx12345";
        MapValue params = BookmarkTest.singletonMap("bookmarks", Arrays.asList(txId1, txId2));
        String actual = new Bookmark(Bookmark.fromParamsOrNull((MapValue)params).txId()).toString();
        Assertions.assertEquals((Object)txId2, (Object)actual);
    }

    @Test
    void shouldFailWhenParsingBadlyFormattedSingleBookmark() {
        String bookmarkString = "neo4q:markbook:v9:xt998";
        BookmarkFormatException e = (BookmarkFormatException)Assertions.assertThrows(BookmarkFormatException.class, () -> Bookmark.fromParamsOrNull((MapValue)BookmarkTest.singletonMap("bookmark", bookmarkString)));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldFailWhenParsingBadlyFormattedMultipleBookmarks() {
        String bookmarkString = "neo4j:bookmark:v1:tx998";
        String wrongBookmarkString = "neo4q:markbook:v9:xt998";
        BookmarkFormatException e = (BookmarkFormatException)Assertions.assertThrows(BookmarkFormatException.class, () -> Bookmark.fromParamsOrNull((MapValue)BookmarkTest.singletonMap("bookmarks", Arrays.asList(bookmarkString, wrongBookmarkString))));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldFailWhenNoNumberFollowsThePrefixInSingleBookmark() {
        String bookmarkString = "neo4j:bookmark:v1:tx";
        BookmarkFormatException e = (BookmarkFormatException)Assertions.assertThrows(BookmarkFormatException.class, () -> Bookmark.fromParamsOrNull((MapValue)BookmarkTest.singletonMap("bookmark", bookmarkString)));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldFailWhenNoNumberFollowsThePrefixInMultipleBookmarks() {
        String bookmarkString = "neo4j:bookmark:v1:tx10";
        String wrongBookmarkString = "neo4j:bookmark:v1:tx";
        BookmarkFormatException e = (BookmarkFormatException)Assertions.assertThrows(BookmarkFormatException.class, () -> Bookmark.fromParamsOrNull((MapValue)BookmarkTest.singletonMap("bookmarks", Arrays.asList(bookmarkString, wrongBookmarkString))));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldFailWhenSingleBookmarkHasExtraneousTrailingCharacters() {
        String bookmarkString = "neo4j:bookmark:v1:tx1234supercalifragilisticexpialidocious";
        BookmarkFormatException e = (BookmarkFormatException)Assertions.assertThrows(BookmarkFormatException.class, () -> Bookmark.fromParamsOrNull((MapValue)BookmarkTest.singletonMap("bookmark", bookmarkString)));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldFailWhenMultipleBookmarksHaveExtraneousTrailingCharacters() {
        String bookmarkString = "neo4j:bookmark:v1:tx1234";
        String wrongBookmarkString = "neo4j:bookmark:v1:tx1234supercalifragilisticexpialidocious";
        BookmarkFormatException e = (BookmarkFormatException)Assertions.assertThrows(BookmarkFormatException.class, () -> Bookmark.fromParamsOrNull((MapValue)BookmarkTest.singletonMap("bookmarks", Arrays.asList(bookmarkString, wrongBookmarkString))));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldUseMultipleBookmarksWhenGivenBothSingleAndMultiple() throws Exception {
        MapValue params = BookmarkTest.params("neo4j:bookmark:v1:tx42", Arrays.asList("neo4j:bookmark:v1:tx10", "neo4j:bookmark:v1:tx99", "neo4j:bookmark:v1:tx3"));
        Bookmark bookmark = Bookmark.fromParamsOrNull((MapValue)params);
        Assertions.assertEquals((long)99L, (long)bookmark.txId());
    }

    @Test
    void shouldUseMultipleBookmarksWhenGivenOnlyMultiple() throws Exception {
        MapValue params = BookmarkTest.params(null, Arrays.asList("neo4j:bookmark:v1:tx85", "neo4j:bookmark:v1:tx47", "neo4j:bookmark:v1:tx15", "neo4j:bookmark:v1:tx6"));
        Bookmark bookmark = Bookmark.fromParamsOrNull((MapValue)params);
        Assertions.assertEquals((long)85L, (long)bookmark.txId());
    }

    @Test
    void shouldUseSingleBookmarkWhenGivenOnlySingle() throws Exception {
        MapValue params = BookmarkTest.params("neo4j:bookmark:v1:tx82", null);
        Bookmark bookmark = Bookmark.fromParamsOrNull((MapValue)params);
        Assertions.assertEquals((long)82L, (long)bookmark.txId());
    }

    @Test
    void shouldUseSingleBookmarkWhenGivenBothSingleAndNullAsMultiple() throws Exception {
        MapValue params = BookmarkTest.params("neo4j:bookmark:v1:tx58", null);
        Bookmark bookmark = Bookmark.fromParamsOrNull((MapValue)params);
        Assertions.assertEquals((long)58L, (long)bookmark.txId());
    }

    @Test
    void shouldUseSingleBookmarkWhenGivenBothSingleAndEmptyListAsMultiple() throws Exception {
        MapValue params = BookmarkTest.params("neo4j:bookmark:v1:tx67", Collections.emptyList());
        Bookmark bookmark = Bookmark.fromParamsOrNull((MapValue)params);
        Assertions.assertEquals((long)67L, (long)bookmark.txId());
    }

    @Test
    void shouldThrowWhenMultipleBookmarksIsNotAList() {
        MapValue params = BookmarkTest.params("neo4j:bookmark:v1:tx67", new String[]{"neo4j:bookmark:v1:tx68"});
        BookmarkFormatException e = (BookmarkFormatException)Assertions.assertThrows(BookmarkFormatException.class, () -> Bookmark.fromParamsOrNull((MapValue)params));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldThrowWhenMultipleBookmarksIsNotAListOfStrings() {
        MapValue params = BookmarkTest.params("neo4j:bookmark:v1:tx67", Arrays.asList({"neo4j:bookmark:v1:tx50"}, {"neo4j:bookmark:v1:tx89"}));
        BookmarkFormatException e = (BookmarkFormatException)Assertions.assertThrows(BookmarkFormatException.class, () -> Bookmark.fromParamsOrNull((MapValue)params));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldThrowWhenOneOfMultipleBookmarksIsMalformed() {
        MapValue params = BookmarkTest.params("neo4j:bookmark:v1:tx67", Arrays.asList("neo4j:bookmark:v1:tx99", "neo4j:bookmark:v1:tx12", "neo4j:bookmark:www:tx99"));
        BookmarkFormatException e = (BookmarkFormatException)Assertions.assertThrows(BookmarkFormatException.class, () -> Bookmark.fromParamsOrNull((MapValue)params));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldThrowWhenSingleBookmarkIsMalformed() {
        MapValue params = BookmarkTest.params("neo4j:strange-bookmark:v1:tx6", null);
        BookmarkFormatException e = (BookmarkFormatException)Assertions.assertThrows(BookmarkFormatException.class, () -> Bookmark.fromParamsOrNull((MapValue)params));
        Assertions.assertTrue((boolean)e.causesFailureMessage());
    }

    @Test
    void shouldReturnNullWhenNoBookmarks() throws Exception {
        Assertions.assertNull((Object)Bookmark.fromParamsOrNull((MapValue)VirtualValues.EMPTY_MAP));
    }

    @Test
    void shouldReturnNullWhenGivenEmptyListForMultipleBookmarks() throws Exception {
        MapValue params = BookmarkTest.params(null, Collections.emptyList());
        Assertions.assertNull((Object)Bookmark.fromParamsOrNull((MapValue)params));
    }

    @Test
    void shouldSkipNullsInMultipleBookmarks() throws Exception {
        MapValue params = BookmarkTest.params(null, Arrays.asList("neo4j:bookmark:v1:tx3", "neo4j:bookmark:v1:tx5", null, "neo4j:bookmark:v1:tx17"));
        Bookmark bookmark = Bookmark.fromParamsOrNull((MapValue)params);
        Assertions.assertEquals((long)17L, (long)bookmark.txId());
    }

    private static MapValue params(String bookmark, Object bookmarks) {
        MapValueBuilder builder = new MapValueBuilder();
        if (bookmark != null) {
            builder.add("bookmark", ValueUtils.of((Object)bookmark));
        }
        builder.add("bookmarks", ValueUtils.of((Object)bookmarks));
        return builder.build();
    }

    private static MapValue singletonMap(String key, Object value) {
        return VirtualValues.map((String[])new String[]{key}, (AnyValue[])new AnyValue[]{ValueUtils.of((Object)value)});
    }
}

