/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.v1.runtime.TransactionStateMachineV1SPI;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.time.FakeClock;

public class TransactionStateMachineV1SPITest {
    @Rule
    public final OtherThreadRule<Void> otherThread = new OtherThreadRule();

    @Test
    public void throwsWhenTxAwaitDurationExpires() {
        long lastClosedTransactionId = 100L;
        Supplier<TransactionIdStore> txIdStore = () -> TransactionStateMachineV1SPITest.fixedTxIdStore(lastClosedTransactionId);
        Duration txAwaitDuration = Duration.ofSeconds(42L);
        FakeClock clock = new FakeClock();
        DatabaseAvailabilityGuard databaseAvailabilityGuard = (DatabaseAvailabilityGuard)Mockito.spy((Object)new DatabaseAvailabilityGuard("graph.db", (Clock)clock, (Log)NullLog.getInstance()));
        Mockito.when((Object)databaseAvailabilityGuard.isAvailable()).then(invocation -> {
            boolean available = (Boolean)invocation.callRealMethod();
            clock.forward(txAwaitDuration.getSeconds() + 1L, TimeUnit.SECONDS);
            return available;
        });
        TransactionStateMachineV1SPI txSpi = TransactionStateMachineV1SPITest.createTxSpi(txIdStore, txAwaitDuration, databaseAvailabilityGuard, (Clock)clock);
        Future result = this.otherThread.execute(state -> {
            txSpi.awaitUpToDate(lastClosedTransactionId + 42L);
            return null;
        });
        try {
            result.get(20L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(ExecutionException.class));
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(TransactionFailureException.class));
        }
    }

    @Test
    public void doesNotWaitWhenTxIdUpToDate() throws Exception {
        long lastClosedTransactionId = 100L;
        Supplier<TransactionIdStore> txIdStore = () -> TransactionStateMachineV1SPITest.fixedTxIdStore(lastClosedTransactionId);
        TransactionStateMachineV1SPI txSpi = TransactionStateMachineV1SPITest.createTxSpi(txIdStore, Duration.ZERO, Clock.systemUTC());
        Future result = this.otherThread.execute(state -> {
            txSpi.awaitUpToDate(lastClosedTransactionId - 42L);
            return null;
        });
        Assert.assertNull(result.get(20L, TimeUnit.SECONDS));
    }

    private static TransactionIdStore fixedTxIdStore(long lastClosedTransactionId) {
        TransactionIdStore txIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)txIdStore.getLastClosedTransactionId()).thenReturn((Object)lastClosedTransactionId);
        return txIdStore;
    }

    private static TransactionStateMachineV1SPI createTxSpi(Supplier<TransactionIdStore> txIdStore, Duration txAwaitDuration, Clock clock) {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = new DatabaseAvailabilityGuard("graph.db", clock, (Log)NullLog.getInstance());
        return TransactionStateMachineV1SPITest.createTxSpi(txIdStore, txAwaitDuration, databaseAvailabilityGuard, clock);
    }

    private static TransactionStateMachineV1SPI createTxSpi(Supplier<TransactionIdStore> txIdStore, Duration txAwaitDuration, DatabaseAvailabilityGuard availabilityGuard, Clock clock) {
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        ThreadToStatementContextBridge bridge = new ThreadToStatementContextBridge((AvailabilityGuard)availabilityGuard);
        Mockito.when((Object)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class)).thenReturn((Object)bridge);
        Mockito.when((Object)dependencyResolver.resolveDependency(QueryExecutionEngine.class)).thenReturn((Object)queryExecutionEngine);
        Mockito.when((Object)dependencyResolver.resolveDependency(DatabaseAvailabilityGuard.class)).thenReturn((Object)availabilityGuard);
        Mockito.when((Object)dependencyResolver.provideDependency(TransactionIdStore.class)).thenReturn(txIdStore);
        GraphDatabaseAPI db = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        Mockito.when((Object)db.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        Mockito.when((Object)queryService.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)dependencyResolver.resolveDependency(GraphDatabaseQueryService.class)).thenReturn((Object)queryService);
        BoltChannel boltChannel = new BoltChannel("bolt-42", "bolt", (Channel)new EmbeddedChannel());
        return new TransactionStateMachineV1SPI(db, boltChannel, txAwaitDuration, clock);
    }
}

