/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.BoltResultHandle;
import org.neo4j.bolt.runtime.TransactionStateMachineSPI;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.bolt.v1.runtime.TransactionStateMachineV1SPI;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.time.FakeClock;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class TransactionStateMachineTest {
    private static final String PERIODIC_COMMIT_QUERY = "USING PERIODIC COMMIT 1 LOAD CSV FROM ''https://neo4j.com/test.csv'' AS line CREATE (:Node {id: line[0], name: line[1]})";
    private TransactionStateMachineV1SPI stateMachineSPI;
    private TransactionStateMachine.MutableTransactionState mutableState;
    private TransactionStateMachine stateMachine;

    TransactionStateMachineTest() {
    }

    @BeforeEach
    void createMocks() {
        this.stateMachineSPI = (TransactionStateMachineV1SPI)Mockito.mock(TransactionStateMachineV1SPI.class);
        this.mutableState = (TransactionStateMachine.MutableTransactionState)Mockito.mock(TransactionStateMachine.MutableTransactionState.class);
        this.stateMachine = new TransactionStateMachine((TransactionStateMachineSPI)this.stateMachineSPI, AuthenticationResult.AUTH_DISABLED, (Clock)new FakeClock());
    }

    @Test
    void shouldTransitionToExplicitTransactionOnBegin() throws Exception {
        Assert.assertEquals((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION, (Object)TransactionStateMachine.State.AUTO_COMMIT.beginTransaction(this.mutableState, (TransactionStateMachineSPI)this.stateMachineSPI, null, null, null));
    }

    @Test
    void shouldTransitionToAutoCommitOnCommit() throws Exception {
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT, (Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.commitTransaction(this.mutableState, (TransactionStateMachineSPI)this.stateMachineSPI));
    }

    @Test
    void shouldTransitionToAutoCommitOnRollback() throws Exception {
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT, (Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION.rollbackTransaction(this.mutableState, (TransactionStateMachineSPI)this.stateMachineSPI));
    }

    @Test
    void shouldThrowOnBeginInExplicitTransaction() throws Exception {
        QueryExecutionKernelException e = (QueryExecutionKernelException)Assertions.assertThrows(QueryExecutionKernelException.class, () -> TransactionStateMachine.State.EXPLICIT_TRANSACTION.beginTransaction(this.mutableState, (TransactionStateMachineSPI)this.stateMachineSPI, null, null, null));
        Assert.assertEquals((Object)"Nested transactions are not supported.", (Object)e.getMessage());
    }

    @Test
    void shouldAllowRollbackInAutoCommit() throws Exception {
        Assert.assertEquals((Object)TransactionStateMachine.State.AUTO_COMMIT, (Object)TransactionStateMachine.State.AUTO_COMMIT.rollbackTransaction(this.mutableState, (TransactionStateMachineSPI)this.stateMachineSPI));
    }

    @Test
    void shouldThrowOnCommitInAutoCommit() throws Exception {
        QueryExecutionKernelException e = (QueryExecutionKernelException)Assertions.assertThrows(QueryExecutionKernelException.class, () -> TransactionStateMachine.State.AUTO_COMMIT.commitTransaction(this.mutableState, (TransactionStateMachineSPI)this.stateMachineSPI));
        Assert.assertEquals((Object)"No current transaction to commit.", (Object)e.getMessage());
    }

    @Test
    void shouldNotWaitWhenNoBookmarkSupplied() throws Exception {
        this.stateMachine.beginTransaction(null);
        ((TransactionStateMachineV1SPI)Mockito.verify((Object)this.stateMachineSPI, (VerificationMode)Mockito.never())).awaitUpToDate(ArgumentMatchers.anyLong());
    }

    @Test
    void shouldAwaitSingleBookmark() throws Exception {
        MapValue params = TransactionStateMachineTest.map("bookmark", "neo4j:bookmark:v1:tx15");
        this.stateMachine.beginTransaction(Bookmark.fromParamsOrNull((MapValue)params));
        ((TransactionStateMachineV1SPI)Mockito.verify((Object)this.stateMachineSPI)).awaitUpToDate(15L);
    }

    @Test
    void shouldAwaitMultipleBookmarks() throws Exception {
        MapValue params = TransactionStateMachineTest.map("bookmarks", Arrays.asList("neo4j:bookmark:v1:tx15", "neo4j:bookmark:v1:tx5", "neo4j:bookmark:v1:tx92", "neo4j:bookmark:v1:tx9"));
        this.stateMachine.beginTransaction(Bookmark.fromParamsOrNull((MapValue)params));
        ((TransactionStateMachineV1SPI)Mockito.verify((Object)this.stateMachineSPI)).awaitUpToDate(92L);
    }

    @Test
    void shouldAwaitMultipleBookmarksWhenBothSingleAndMultipleSupplied() throws Exception {
        MapValue params = TransactionStateMachineTest.map("bookmark", "neo4j:bookmark:v1:tx42", "bookmarks", Arrays.asList("neo4j:bookmark:v1:tx47", "neo4j:bookmark:v1:tx67", "neo4j:bookmark:v1:tx45"));
        this.stateMachine.beginTransaction(Bookmark.fromParamsOrNull((MapValue)params));
        ((TransactionStateMachineV1SPI)Mockito.verify((Object)this.stateMachineSPI)).awaitUpToDate(67L);
    }

    @Test
    void shouldStartWithAutoCommitState() {
        TransactionStateMachineV1SPI stateMachineSPI = (TransactionStateMachineV1SPI)Mockito.mock(TransactionStateMachineV1SPI.class);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
    }

    @Test
    void shouldDoNothingInAutoCommitTransactionUponInitialisationWhenValidated() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        stateMachine.validateTransaction();
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).getReasonIfTerminated();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).failure();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).close();
    }

    @Test
    void shouldResetInAutoCommitTransactionWhileStatementIsRunningWhenValidated() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        stateMachine.run("RETURN 1", null);
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNotNull((Object)stateMachine.ctx.currentTransaction);
        stateMachine.validateTransaction();
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).getReasonIfTerminated();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).failure();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    void shouldResetInExplicitTransactionUponTxBeginWhenValidated() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.beginTransaction(null);
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION));
        Assert.assertNotNull((Object)stateMachine.ctx.currentTransaction);
        stateMachine.validateTransaction();
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).getReasonIfTerminated();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).failure();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    void shouldResetInExplicitTransactionWhileStatementIsRunningWhenValidated() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.beginTransaction(null);
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.EXPLICIT_TRANSACTION));
        Assert.assertNotNull((Object)stateMachine.ctx.currentTransaction);
        stateMachine.run("RETURN 1", null);
        stateMachine.validateTransaction();
        Assert.assertThat((Object)stateMachine.state, (Matcher)CoreMatchers.is((Object)TransactionStateMachine.State.AUTO_COMMIT));
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).getReasonIfTerminated();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).failure();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    void shouldUnbindTxAfterRun() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("SOME STATEMENT", null);
        ((TransactionStateMachineV1SPI)Mockito.verify((Object)stateMachineSPI, (VerificationMode)Mockito.times((int)1))).unbindTransactionFromCurrentThread();
    }

    @Test
    void shouldUnbindTxAfterStreamResult() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("SOME STATEMENT", null);
        stateMachine.streamResult(boltResult -> {});
        ((TransactionStateMachineV1SPI)Mockito.verify((Object)stateMachineSPI, (VerificationMode)Mockito.times((int)2))).unbindTransactionFromCurrentThread();
    }

    @Test
    void shouldThrowDuringRunIfPendingTerminationNoticeExists() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.ctx.pendingTerminationNotice = Status.Transaction.TransactionTimedOut;
        TransactionTerminatedException e = (TransactionTerminatedException)Assertions.assertThrows(TransactionTerminatedException.class, () -> stateMachine.run("SOME STATEMENT", null));
        Assert.assertEquals((Object)Status.Transaction.TransactionTimedOut, (Object)e.status());
    }

    @Test
    void shouldThrowDuringStreamResultIfPendingTerminationNoticeExists() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTimedOutTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("SOME STATEMENT", null);
        stateMachine.ctx.pendingTerminationNotice = Status.Transaction.TransactionTimedOut;
        TransactionTerminatedException e = (TransactionTerminatedException)Assertions.assertThrows(TransactionTerminatedException.class, () -> stateMachine.streamResult(boltResult -> {}));
        Assert.assertEquals((Object)Status.Transaction.TransactionTimedOut, (Object)e.status());
    }

    @Test
    void shouldCloseResultAndTransactionHandlesWhenExecutionFails() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        BoltResultHandle resultHandle = TransactionStateMachineTest.newResultHandle(new RuntimeException("some error"));
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction, resultHandle);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> stateMachine.run("SOME STATEMENT", null));
        Assert.assertEquals((Object)"some error", (Object)e.getMessage());
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
    }

    @Test
    void shouldCloseResultAndTransactionHandlesWhenConsumeFails() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run("SOME STATEMENT", null);
        Assert.assertNotNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNotNull((Object)stateMachine.ctx.currentResult);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> stateMachine.streamResult(boltResult -> {
            throw new RuntimeException("some error");
        }));
        Assert.assertEquals((Object)"some error", (Object)e.getMessage());
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNull((Object)stateMachine.ctx.currentTransaction);
    }

    @Test
    void shouldCloseResultHandlesWhenExecutionFailsInExplicitTransaction() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        BoltResultHandle resultHandle = TransactionStateMachineTest.newResultHandle(new RuntimeException("some error"));
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction, resultHandle);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> {
            stateMachine.beginTransaction(null);
            stateMachine.streamResult(boltResult -> {});
            stateMachine.run("SOME STATEMENT", null);
        });
        Assert.assertEquals((Object)"some error", (Object)e.getMessage());
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNotNull((Object)stateMachine.ctx.currentTransaction);
    }

    @Test
    void shouldCloseResultHandlesWhenConsumeFailsInExplicitTransaction() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.beginTransaction(null);
        stateMachine.streamResult(boltResult -> {});
        stateMachine.run("SOME STATEMENT", null);
        Assert.assertNotNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNotNull((Object)stateMachine.ctx.currentResult);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> stateMachine.streamResult(boltResult -> {
            throw new RuntimeException("some error");
        }));
        Assert.assertEquals((Object)"some error", (Object)e.getMessage());
        Assert.assertNull((Object)stateMachine.ctx.currentResultHandle);
        Assert.assertNull((Object)stateMachine.ctx.currentResult);
        Assert.assertNotNull((Object)stateMachine.ctx.currentTransaction);
    }

    @Test
    public void shouldNotOpenExplicitTransactionForPeriodicCommitQuery() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        Mockito.when((Object)stateMachineSPI.isPeriodicCommit(PERIODIC_COMMIT_QUERY)).thenReturn((Object)true);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.run(PERIODIC_COMMIT_QUERY, VirtualValues.EMPTY_MAP);
        Assert.assertEquals((Object)transaction, (Object)stateMachine.ctx.currentTransaction);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{stateMachineSPI});
        ((TransactionStateMachineV1SPI)inOrder.verify((Object)stateMachineSPI)).isPeriodicCommit(PERIODIC_COMMIT_QUERY);
        ((TransactionStateMachineV1SPI)inOrder.verify((Object)stateMachineSPI)).executeQuery((LoginContext)ArgumentMatchers.any(LoginContext.class), (String)ArgumentMatchers.eq((Object)PERIODIC_COMMIT_QUERY), (MapValue)ArgumentMatchers.eq((Object)VirtualValues.EMPTY_MAP), (Duration)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ((TransactionStateMachineV1SPI)inOrder.verify((Object)stateMachineSPI)).beginTransaction((LoginContext)ArgumentMatchers.any(LoginContext.class), (Duration)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test
    public void shouldNotMarkForTerminationWhenNoTransaction() throws Exception {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        TransactionStateMachineV1SPI stateMachineSPI = TransactionStateMachineTest.newTransactionStateMachineSPI(transaction);
        TransactionStateMachine stateMachine = TransactionStateMachineTest.newTransactionStateMachine(stateMachineSPI);
        stateMachine.markCurrentTransactionForTermination();
        ((KernelTransaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.never())).markForTermination((Status)ArgumentMatchers.any());
    }

    private static KernelTransaction newTransaction() {
        KernelTransaction transaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Mockito.when((Object)transaction.isOpen()).thenReturn((Object)true);
        return transaction;
    }

    private static KernelTransaction newTimedOutTransaction() {
        KernelTransaction transaction = TransactionStateMachineTest.newTransaction();
        Mockito.when((Object)transaction.getReasonIfTerminated()).thenReturn(Optional.of(Status.Transaction.TransactionTimedOut));
        return transaction;
    }

    private static TransactionStateMachine newTransactionStateMachine(TransactionStateMachineV1SPI stateMachineSPI) {
        return new TransactionStateMachine((TransactionStateMachineSPI)stateMachineSPI, AuthenticationResult.AUTH_DISABLED, (Clock)new FakeClock());
    }

    private static MapValue map(Object ... keyValues) {
        return ValueUtils.asMapValue((Map)MapUtil.map((Object[])keyValues));
    }

    private static TransactionStateMachineV1SPI newTransactionStateMachineSPI(KernelTransaction transaction) throws KernelException {
        BoltResultHandle resultHandle = TransactionStateMachineTest.newResultHandle();
        TransactionStateMachineV1SPI stateMachineSPI = (TransactionStateMachineV1SPI)Mockito.mock(TransactionStateMachineV1SPI.class);
        Mockito.when((Object)stateMachineSPI.beginTransaction((LoginContext)ArgumentMatchers.any(), (Duration)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)transaction);
        Mockito.when((Object)stateMachineSPI.executeQuery((LoginContext)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (MapValue)ArgumentMatchers.any(), (Duration)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)resultHandle);
        return stateMachineSPI;
    }

    private static TransactionStateMachineV1SPI newTransactionStateMachineSPI(KernelTransaction transaction, BoltResultHandle resultHandle) throws KernelException {
        TransactionStateMachineV1SPI stateMachineSPI = (TransactionStateMachineV1SPI)Mockito.mock(TransactionStateMachineV1SPI.class);
        Mockito.when((Object)stateMachineSPI.beginTransaction((LoginContext)ArgumentMatchers.any(), (Duration)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)transaction);
        Mockito.when((Object)stateMachineSPI.executeQuery((LoginContext)ArgumentMatchers.any(), ArgumentMatchers.anyString(), (MapValue)ArgumentMatchers.any(), (Duration)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)resultHandle);
        return stateMachineSPI;
    }

    private static BoltResultHandle newResultHandle() throws KernelException {
        BoltResultHandle resultHandle = (BoltResultHandle)Mockito.mock(BoltResultHandle.class);
        Mockito.when((Object)resultHandle.start()).thenReturn((Object)BoltResult.EMPTY);
        return resultHandle;
    }

    private static BoltResultHandle newResultHandle(Throwable t) throws KernelException {
        BoltResultHandle resultHandle = (BoltResultHandle)Mockito.mock(BoltResultHandle.class);
        Mockito.when((Object)resultHandle.start()).thenThrow(new Throwable[]{t});
        return resultHandle;
    }
}

