/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.MutableConnectionState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.runtime.StatementProcessor;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.runtime.StreamingState;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.values.virtual.VirtualValues;

class StreamingStateTest {
    private final StreamingState state = new StreamingState();
    private final BoltStateMachineState readyState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final BoltStateMachineState interruptedState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final BoltStateMachineState failedState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final StateMachineContext context = (StateMachineContext)Mockito.mock(StateMachineContext.class);
    private final MutableConnectionState connectionState = new MutableConnectionState();

    StreamingStateTest() {
    }

    @BeforeEach
    void setUp() {
        this.state.setReadyState(this.readyState);
        this.state.setInterruptedState(this.interruptedState);
        this.state.setFailedState(this.failedState);
        Mockito.when((Object)this.context.connectionState()).thenReturn((Object)this.connectionState);
    }

    @Test
    void shouldThrowWhenNotInitialized() throws Exception {
        StreamingState state = new StreamingState();
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)PullAllMessage.INSTANCE, this.context));
        state.setReadyState(this.readyState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)PullAllMessage.INSTANCE, this.context));
        state.setReadyState(null);
        state.setInterruptedState(this.interruptedState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)PullAllMessage.INSTANCE, this.context));
        state.setInterruptedState(null);
        state.setFailedState(this.failedState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)PullAllMessage.INSTANCE, this.context));
    }

    @Test
    void shouldProcessPullAllMessage() throws Exception {
        StatementProcessor statementProcessor = (StatementProcessor)Mockito.mock(StatementProcessor.class);
        this.connectionState.setStatementProcessor(statementProcessor);
        BoltStateMachineState nextState = this.state.process((RequestMessage)PullAllMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)nextState);
        ((StatementProcessor)Mockito.verify((Object)statementProcessor)).streamResult((ThrowingConsumer)ArgumentMatchers.any());
    }

    @Test
    void shouldHandleAuthErrorWhenProcessingPullAllMessage() throws Exception {
        AuthorizationExpiredException error = new AuthorizationExpiredException("Hello");
        StatementProcessor statementProcessor = (StatementProcessor)Mockito.mock(StatementProcessor.class);
        ((StatementProcessor)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)statementProcessor)).streamResult((ThrowingConsumer)ArgumentMatchers.any());
        this.connectionState.setStatementProcessor(statementProcessor);
        BoltStateMachineState nextState = this.state.process((RequestMessage)PullAllMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.failedState, (Object)nextState);
        ((StateMachineContext)Mockito.verify((Object)this.context)).handleFailure((Throwable)error, true);
    }

    @Test
    void shouldHandleErrorWhenProcessingPullAllMessage() throws Exception {
        RuntimeException error = new RuntimeException("Hello");
        StatementProcessor statementProcessor = (StatementProcessor)Mockito.mock(StatementProcessor.class);
        ((StatementProcessor)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)statementProcessor)).streamResult((ThrowingConsumer)ArgumentMatchers.any());
        this.connectionState.setStatementProcessor(statementProcessor);
        BoltStateMachineState nextState = this.state.process((RequestMessage)PullAllMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.failedState, (Object)nextState);
        ((StateMachineContext)Mockito.verify((Object)this.context)).handleFailure((Throwable)error, false);
    }

    @Test
    void shouldProcessDiscardAllMessage() throws Exception {
        StatementProcessor statementProcessor = (StatementProcessor)Mockito.mock(StatementProcessor.class);
        this.connectionState.setStatementProcessor(statementProcessor);
        BoltStateMachineState nextState = this.state.process((RequestMessage)DiscardAllMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)nextState);
        ((StatementProcessor)Mockito.verify((Object)statementProcessor)).streamResult((ThrowingConsumer)ArgumentMatchers.any());
    }

    @Test
    void shouldHandleAuthErrorWhenProcessingDiscardAllMessage() throws Exception {
        AuthorizationExpiredException error = new AuthorizationExpiredException("Hello");
        StatementProcessor statementProcessor = (StatementProcessor)Mockito.mock(StatementProcessor.class);
        ((StatementProcessor)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)statementProcessor)).streamResult((ThrowingConsumer)ArgumentMatchers.any());
        this.connectionState.setStatementProcessor(statementProcessor);
        BoltStateMachineState nextState = this.state.process((RequestMessage)DiscardAllMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.failedState, (Object)nextState);
        ((StateMachineContext)Mockito.verify((Object)this.context)).handleFailure((Throwable)error, true);
    }

    @Test
    void shouldHandleErrorWhenProcessingDiscardAllMessage() throws Exception {
        RuntimeException error = new RuntimeException("Hello");
        StatementProcessor statementProcessor = (StatementProcessor)Mockito.mock(StatementProcessor.class);
        ((StatementProcessor)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)statementProcessor)).streamResult((ThrowingConsumer)ArgumentMatchers.any());
        this.connectionState.setStatementProcessor(statementProcessor);
        BoltStateMachineState nextState = this.state.process((RequestMessage)DiscardAllMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.failedState, (Object)nextState);
        ((StateMachineContext)Mockito.verify((Object)this.context)).handleFailure((Throwable)error, false);
    }

    @Test
    void shouldProcessResetMessage() throws Exception {
        Mockito.when((Object)this.context.resetMachine()).thenReturn((Object)true);
        BoltStateMachineState newState = this.state.process((RequestMessage)ResetMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
    }

    @Test
    void shouldHandleResetMessageFailure() throws Exception {
        Mockito.when((Object)this.context.resetMachine()).thenReturn((Object)false);
        BoltStateMachineState newState = this.state.process((RequestMessage)ResetMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.failedState, (Object)newState);
    }

    @Test
    void shouldProcessInterruptMessage() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)InterruptSignal.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.interruptedState, (Object)newState);
    }

    @Test
    void shouldNotProcessUnsupportedMessages() throws Exception {
        List<RequestMessage> unsupportedMessages = Arrays.asList(AckFailureMessage.INSTANCE, new RunMessage("RETURN 1", VirtualValues.EMPTY_MAP), new InitMessage("Driver 2.5", Collections.emptyMap()));
        for (RequestMessage message : unsupportedMessages) {
            Assertions.assertNull((Object)this.state.process(message, this.context));
        }
    }
}

