/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.runtime.RunMessageChecker;

class RunMessageCheckerTest {
    RunMessageCheckerTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"begin", "BEGIN", "   begin   ", "   BeGiN ;   ", " begin     ;"})
    void shouldCheckBegin(String statement) {
        Assertions.assertTrue((boolean)RunMessageChecker.isBegin((RunMessage)new RunMessage(statement)));
    }

    @ParameterizedTest
    @ValueSource(strings={"commit", "COMMIT", "   commit   ", "   CoMmIt ;   ", " commiT     ;"})
    void shouldCheckCommit(String statement) {
        Assertions.assertTrue((boolean)RunMessageChecker.isCommit((RunMessage)new RunMessage(statement)));
    }

    @ParameterizedTest
    @ValueSource(strings={"rollback", "ROLLBACK", "   rollback   ", "   RoLlBaCk ;   ", " Rollback     ;"})
    void shouldCheckRollback(String statement) {
        Assertions.assertTrue((boolean)RunMessageChecker.isRollback((RunMessage)new RunMessage(statement)));
    }

    @ParameterizedTest
    @ValueSource(strings={"RETURN 1", "CREATE ()", "MATCH (n) RETURN n", "RETURN 'Hello World!'"})
    void shouldCheckStatement(String statement) {
        Assertions.assertFalse((boolean)RunMessageChecker.isBegin((RunMessage)new RunMessage(statement)));
        Assertions.assertFalse((boolean)RunMessageChecker.isCommit((RunMessage)new RunMessage(statement)));
        Assertions.assertFalse((boolean)RunMessageChecker.isRollback((RunMessage)new RunMessage(statement)));
    }
}

