/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.MutableConnectionState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.runtime.StatementMetadata;
import org.neo4j.bolt.runtime.StatementProcessor;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.runtime.ReadyState;
import org.neo4j.bolt.v1.runtime.bookmarking.Bookmark;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

class ReadyStateTest {
    private final ReadyState state = new ReadyState();
    private final BoltStateMachineState streamingState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final BoltStateMachineState interruptedState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final BoltStateMachineState failedState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final StatementProcessor statementProcessor = (StatementProcessor)Mockito.mock(StatementProcessor.class);
    private final StateMachineContext context = (StateMachineContext)Mockito.mock(StateMachineContext.class);
    private final MutableConnectionState connectionState = new MutableConnectionState();

    ReadyStateTest() {
    }

    @BeforeEach
    void setUp() {
        this.state.setStreamingState(this.streamingState);
        this.state.setInterruptedState(this.interruptedState);
        this.state.setFailedState(this.failedState);
        Mockito.when((Object)this.context.connectionState()).thenReturn((Object)this.connectionState);
        Mockito.when((Object)this.context.clock()).thenReturn((Object)Clock.systemUTC());
        this.connectionState.setStatementProcessor(this.statementProcessor);
    }

    @Test
    void shouldThrowWhenNotInitialized() throws Exception {
        ReadyState state = new ReadyState();
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)PullAllMessage.INSTANCE, this.context));
        state.setStreamingState(this.streamingState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)PullAllMessage.INSTANCE, this.context));
        state.setStreamingState(null);
        state.setInterruptedState(this.interruptedState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)PullAllMessage.INSTANCE, this.context));
        state.setInterruptedState(null);
        state.setFailedState(this.failedState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)PullAllMessage.INSTANCE, this.context));
    }

    @Test
    void shouldProcessRunMessage() throws Exception {
        StatementMetadata statementMetadata = (StatementMetadata)Mockito.mock(StatementMetadata.class);
        Mockito.when((Object)statementMetadata.fieldNames()).thenReturn((Object)new String[]{"foo", "bar", "baz"});
        Mockito.when((Object)this.statementProcessor.run((String)ArgumentMatchers.any(), (MapValue)ArgumentMatchers.any())).thenReturn((Object)statementMetadata);
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        this.connectionState.setResponseHandler(responseHandler);
        BoltStateMachineState nextState = this.state.process((RequestMessage)new RunMessage("RETURN 1", VirtualValues.EMPTY_MAP), this.context);
        Assertions.assertEquals((Object)this.streamingState, (Object)nextState);
        ((StatementProcessor)Mockito.verify((Object)this.statementProcessor)).run("RETURN 1", VirtualValues.EMPTY_MAP);
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler)).onMetadata("fields", (AnyValue)Values.stringArray((String[])new String[]{"foo", "bar", "baz"}));
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler)).onMetadata((String)ArgumentMatchers.eq((Object)"result_available_after"), (AnyValue)ArgumentMatchers.any());
    }

    @Test
    void shouldHandleAuthFailureDuringRunMessageProcessing() throws Exception {
        AuthorizationExpiredException error = new AuthorizationExpiredException("Hello");
        Mockito.when((Object)this.statementProcessor.run((String)ArgumentMatchers.any(), (MapValue)ArgumentMatchers.any())).thenThrow(new Throwable[]{error});
        BoltStateMachineState nextState = this.state.process((RequestMessage)new RunMessage("RETURN 1", VirtualValues.EMPTY_MAP), this.context);
        Assertions.assertEquals((Object)this.failedState, (Object)nextState);
        ((StateMachineContext)Mockito.verify((Object)this.context)).handleFailure((Throwable)error, true);
    }

    @Test
    void shouldHandleFailureDuringRunMessageProcessing() throws Exception {
        RuntimeException error = new RuntimeException("Hello");
        Mockito.when((Object)this.statementProcessor.run((String)ArgumentMatchers.any(), (MapValue)ArgumentMatchers.any())).thenThrow(new Throwable[]{error});
        BoltStateMachineState nextState = this.state.process((RequestMessage)new RunMessage("RETURN 1", VirtualValues.EMPTY_MAP), this.context);
        Assertions.assertEquals((Object)this.failedState, (Object)nextState);
        ((StateMachineContext)Mockito.verify((Object)this.context)).handleFailure((Throwable)error, false);
    }

    @Test
    void shouldProcessResetMessage() throws Exception {
        Mockito.when((Object)this.context.resetMachine()).thenReturn((Object)true);
        BoltStateMachineState newState = this.state.process((RequestMessage)ResetMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.state, (Object)newState);
    }

    @Test
    void shouldHandleFailureDuringResetMessageProcessing() throws Exception {
        Mockito.when((Object)this.context.resetMachine()).thenReturn((Object)false);
        BoltStateMachineState newState = this.state.process((RequestMessage)ResetMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.failedState, (Object)newState);
    }

    @Test
    void shouldProcessInterruptMessage() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)InterruptSignal.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.interruptedState, (Object)newState);
    }

    @Test
    void shouldNotProcessUnsupportedMessages() throws Exception {
        List<RequestMessage> unsupportedMessages = Arrays.asList(PullAllMessage.INSTANCE, DiscardAllMessage.INSTANCE, AckFailureMessage.INSTANCE);
        for (RequestMessage message : unsupportedMessages) {
            Assertions.assertNull((Object)this.state.process(message, this.context));
        }
    }

    @Test
    void shouldBeginTransactionWithoutBookmark() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)new RunMessage("BEGIN", VirtualValues.EMPTY_MAP), this.context);
        Assertions.assertEquals((Object)this.streamingState, (Object)newState);
        ((StatementProcessor)Mockito.verify((Object)this.statementProcessor)).beginTransaction(null);
    }

    @Test
    void shouldBeginTransactionWithSingleBookmark() throws Exception {
        Map params = MapUtil.map((Object[])new Object[]{"bookmark", "neo4j:bookmark:v1:tx15"});
        BoltStateMachineState newState = this.state.process((RequestMessage)new RunMessage("BEGIN", ValueUtils.asMapValue((Map)params)), this.context);
        Assertions.assertEquals((Object)this.streamingState, (Object)newState);
        ((StatementProcessor)Mockito.verify((Object)this.statementProcessor)).beginTransaction(new Bookmark(15L));
    }

    @Test
    void shouldBeginTransactionWithMultipleBookmarks() throws Exception {
        Map params = MapUtil.map((Object[])new Object[]{"bookmarks", Arrays.asList("neo4j:bookmark:v1:tx7", "neo4j:bookmark:v1:tx1", "neo4j:bookmark:v1:tx92", "neo4j:bookmark:v1:tx39")});
        BoltStateMachineState newState = this.state.process((RequestMessage)new RunMessage("BEGIN", ValueUtils.asMapValue((Map)params)), this.context);
        Assertions.assertEquals((Object)this.streamingState, (Object)newState);
        ((StatementProcessor)Mockito.verify((Object)this.statementProcessor)).beginTransaction(new Bookmark(92L));
    }

    @ParameterizedTest
    @ValueSource(strings={"begin", "BEGIN", "   begin   ", "   BeGiN ;   "})
    void shouldBeginTransaction(String statement) throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)new RunMessage(statement), this.context);
        Assertions.assertEquals((Object)this.streamingState, (Object)newState);
        ((StatementProcessor)Mockito.verify((Object)this.statementProcessor)).beginTransaction((Bookmark)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @ValueSource(strings={"commit", "COMMIT", "   commit   ", "   CoMmIt ;   "})
    void shouldCommitTransaction(String statement) throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)new RunMessage(statement), this.context);
        Assertions.assertEquals((Object)this.streamingState, (Object)newState);
        ((StatementProcessor)Mockito.verify((Object)this.statementProcessor)).commitTransaction();
    }

    @ParameterizedTest
    @ValueSource(strings={"rollback", "ROLLBACK", "   rollback   ", "   RoLlBaCk ;   "})
    void shouldRollbackTransaction(String statement) throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)new RunMessage(statement), this.context);
        Assertions.assertEquals((Object)this.streamingState, (Object)newState);
        ((StatementProcessor)Mockito.verify((Object)this.statementProcessor)).rollbackTransaction();
    }
}

