/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Collections;
import org.hamcrest.MatcherAssert;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.TransactionStateMachineSPI;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltTestUtil;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.runtime.BoltStateMachineV1;
import org.neo4j.bolt.v1.runtime.BoltStateMachineV1SPI;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class MachineRoom {
    static final MapValue EMPTY_PARAMS = VirtualValues.EMPTY_MAP;
    static final String USER_AGENT = "BoltStateMachineTest/0.0";

    private MachineRoom() {
    }

    public static BoltStateMachine newMachine() {
        return MachineRoom.newMachine((BoltStateMachineV1SPI)Mockito.mock(BoltStateMachineV1SPI.class, (Answer)Mockito.RETURNS_MOCKS));
    }

    public static BoltStateMachine newMachine(BoltStateMachineV1SPI spi) {
        BoltChannel boltChannel = BoltTestUtil.newTestBoltChannel();
        return new BoltStateMachineV1((BoltStateMachineSPI)spi, boltChannel, Clock.systemUTC());
    }

    public static BoltStateMachine newMachineWithTransaction() throws AuthenticationException, BoltConnectionFatality {
        BoltStateMachine machine = MachineRoom.newMachine();
        MachineRoom.init(machine);
        MachineRoom.runBegin(machine);
        return machine;
    }

    public static BoltStateMachine newMachineWithTransactionSPI(TransactionStateMachineSPI transactionSPI) throws AuthenticationException, BoltConnectionFatality {
        BoltStateMachineSPI spi = (BoltStateMachineSPI)Mockito.mock(BoltStateMachineSPI.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)spi.transactionSpi()).thenReturn((Object)transactionSPI);
        BoltChannel boltChannel = BoltTestUtil.newTestBoltChannel();
        BoltStateMachineV1 machine = new BoltStateMachineV1(spi, boltChannel, Clock.systemUTC());
        MachineRoom.init((BoltStateMachine)machine);
        return machine;
    }

    public static BoltStateMachine init(BoltStateMachine machine) throws AuthenticationException, BoltConnectionFatality {
        return MachineRoom.init(machine, null);
    }

    private static BoltStateMachine init(BoltStateMachine machine, String owner) throws AuthenticationException, BoltConnectionFatality {
        machine.process((RequestMessage)new InitMessage(USER_AGENT, owner == null ? Collections.emptyMap() : Collections.singletonMap("principal", owner)), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        return machine;
    }

    private static void runBegin(BoltStateMachine machine) throws BoltConnectionFatality {
        machine.process((RequestMessage)new RunMessage("BEGIN", EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)DiscardAllMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.hasTransaction());
    }
}

