/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.MutableConnectionState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.runtime.InterruptedState;
import org.neo4j.values.virtual.VirtualValues;

class InterruptedStateTest {
    private final InterruptedState state = new InterruptedState();
    private final BoltStateMachineState readyState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final BoltStateMachineState failedState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final StateMachineContext context = (StateMachineContext)Mockito.mock(StateMachineContext.class);
    private final MutableConnectionState connectionState = new MutableConnectionState();

    InterruptedStateTest() {
    }

    @BeforeEach
    void setUp() {
        this.state.setReadyState(this.readyState);
        this.state.setFailedState(this.failedState);
        Mockito.when((Object)this.context.connectionState()).thenReturn((Object)this.connectionState);
    }

    @Test
    void shouldThrowWhenNotInitialized() throws Exception {
        InterruptedState state = new InterruptedState();
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)ResetMessage.INSTANCE, this.context));
        state.setReadyState(this.readyState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)ResetMessage.INSTANCE, this.context));
        state.setReadyState(null);
        state.setFailedState(this.failedState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)ResetMessage.INSTANCE, this.context));
    }

    @Test
    void shouldProcessInterruptMessage() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)InterruptSignal.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.state, (Object)newState);
    }

    @Test
    void shouldProcessResetMessageWhenInterrupted() throws Exception {
        this.connectionState.incrementInterruptCounter();
        this.connectionState.incrementInterruptCounter();
        Assertions.assertTrue((boolean)this.connectionState.isInterrupted());
        Assertions.assertFalse((boolean)this.connectionState.hasPendingIgnore());
        BoltStateMachineState newState = this.state.process((RequestMessage)ResetMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.state, (Object)newState);
        Assertions.assertTrue((boolean)this.connectionState.hasPendingIgnore());
    }

    @Test
    void shouldProcessResetMessage() throws Exception {
        Mockito.when((Object)this.context.resetMachine()).thenReturn((Object)true);
        BoltStateMachineState newState = this.state.process((RequestMessage)ResetMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
    }

    @Test
    void shouldHandleFailureDuringResetMessageProcessing() throws Exception {
        Mockito.when((Object)this.context.resetMachine()).thenReturn((Object)false);
        BoltStateMachineState newState = this.state.process((RequestMessage)ResetMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.failedState, (Object)newState);
    }

    @Test
    void shouldIgnoreMessagesOtherThanInterruptAndReset() throws Exception {
        List<RequestMessage> messages = Arrays.asList(AckFailureMessage.INSTANCE, PullAllMessage.INSTANCE, DiscardAllMessage.INSTANCE, new RunMessage("RETURN 1", VirtualValues.EMPTY_MAP), new InitMessage("Driver", Collections.emptyMap()));
        for (RequestMessage message : messages) {
            this.connectionState.resetPendingFailedAndIgnored();
            BoltStateMachineState newState = this.state.process(message, this.context);
            Assertions.assertEquals((Object)this.state, (Object)newState);
            Assertions.assertTrue((boolean)this.connectionState.hasPendingIgnore());
        }
    }
}

