/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.MutableConnectionState;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.runtime.FailedState;
import org.neo4j.values.virtual.VirtualValues;

class FailedStateTest {
    private final FailedState state = new FailedState();
    private final BoltStateMachineState readyState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final BoltStateMachineState interruptedState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final StateMachineContext context = (StateMachineContext)Mockito.mock(StateMachineContext.class);
    private final MutableConnectionState connectionState = new MutableConnectionState();

    FailedStateTest() {
    }

    @BeforeEach
    void setUp() {
        this.state.setReadyState(this.readyState);
        this.state.setInterruptedState(this.interruptedState);
        Mockito.when((Object)this.context.connectionState()).thenReturn((Object)this.connectionState);
    }

    @Test
    void shouldThrowWhenNotInitialized() throws Exception {
        FailedState state = new FailedState();
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)AckFailureMessage.INSTANCE, this.context));
        state.setReadyState(this.readyState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)AckFailureMessage.INSTANCE, this.context));
        state.setReadyState(null);
        state.setInterruptedState(this.interruptedState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)AckFailureMessage.INSTANCE, this.context));
    }

    @Test
    void shouldProcessRunMessage() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)new RunMessage("RETURN 1", VirtualValues.EMPTY_MAP), this.context);
        Assertions.assertEquals((Object)this.state, (Object)newState);
        Assertions.assertTrue((boolean)this.connectionState.hasPendingIgnore());
    }

    @Test
    void shouldProcessPullAllMessage() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)PullAllMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.state, (Object)newState);
        Assertions.assertTrue((boolean)this.connectionState.hasPendingIgnore());
    }

    @Test
    void shouldProcessDiscardAllMessage() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)DiscardAllMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.state, (Object)newState);
        Assertions.assertTrue((boolean)this.connectionState.hasPendingIgnore());
    }

    @Test
    void shouldProcessAckFailureMessageWithPendingIgnore() throws Exception {
        this.connectionState.markIgnored();
        Assertions.assertTrue((boolean)this.connectionState.hasPendingIgnore());
        BoltStateMachineState newState = this.state.process((RequestMessage)AckFailureMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
        Assertions.assertFalse((boolean)this.connectionState.hasPendingIgnore());
    }

    @Test
    void shouldProcessAckFailureMessageWithPendingError() throws Exception {
        Neo4jError error = Neo4jError.from((Throwable)new RuntimeException());
        this.connectionState.markFailed(error);
        Assertions.assertEquals((Object)error, (Object)this.connectionState.getPendingError());
        BoltStateMachineState newState = this.state.process((RequestMessage)AckFailureMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
        Assertions.assertNull((Object)this.connectionState.getPendingError());
    }

    @Test
    void shouldProcessResetMessageWithPerndingIgnore() throws Exception {
        Mockito.when((Object)this.context.resetMachine()).thenReturn((Object)true);
        this.connectionState.markIgnored();
        Assertions.assertTrue((boolean)this.connectionState.hasPendingIgnore());
        BoltStateMachineState newState = this.state.process((RequestMessage)ResetMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
        Assertions.assertFalse((boolean)this.connectionState.hasPendingIgnore());
    }

    @Test
    void shouldProcessResetMessageWithPerndingError() throws Exception {
        Mockito.when((Object)this.context.resetMachine()).thenReturn((Object)true);
        Neo4jError error = Neo4jError.from((Throwable)new RuntimeException());
        this.connectionState.markFailed(error);
        Assertions.assertEquals((Object)error, (Object)this.connectionState.getPendingError());
        BoltStateMachineState newState = this.state.process((RequestMessage)ResetMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
        Assertions.assertNull((Object)this.connectionState.getPendingError());
    }

    @Test
    void shouldHandleResetMessageFailure() throws Exception {
        Mockito.when((Object)this.context.resetMachine()).thenReturn((Object)false);
        BoltStateMachineState newState = this.state.process((RequestMessage)ResetMessage.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.state, (Object)newState);
    }

    @Test
    void shouldProcessInterruptMessage() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)InterruptSignal.INSTANCE, this.context);
        Assertions.assertEquals((Object)this.interruptedState, (Object)newState);
    }

    @Test
    void shouldNotProcessUnsupportedMessage() throws Exception {
        RequestMessage unsupportedMessage = (RequestMessage)Mockito.mock(RequestMessage.class);
        BoltStateMachineState newState = this.state.process(unsupportedMessage, this.context);
        Assertions.assertNull((Object)newState);
    }
}

