/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.runtime.ExecutionPlanConverter;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class ExecutionPlanConverterTest {
    @Test
    public void profileStatisticConversion() {
        MapValue convertedMap = ExecutionPlanConverter.convert((ExecutionPlanDescription)new TestExecutionPlanDescription("description", this.getProfilerStatistics(), this.getIdentifiers(), this.getArguments()));
        Assert.assertEquals((Object)convertedMap.get("operatorType"), (Object)Values.stringValue((String)"description"));
        Assert.assertEquals((Object)convertedMap.get("args"), (Object)ValueUtils.asMapValue(this.getArguments()));
        Assert.assertEquals((Object)convertedMap.get("identifiers"), (Object)ValueUtils.asListValue(this.getIdentifiers()));
        Assert.assertEquals((Object)convertedMap.get("children"), (Object)VirtualValues.EMPTY_LIST);
        Assert.assertEquals((Object)convertedMap.get("rows"), (Object)Values.longValue((long)1L));
        Assert.assertEquals((Object)convertedMap.get("dbHits"), (Object)Values.longValue((long)2L));
        Assert.assertEquals((Object)convertedMap.get("pageCacheHits"), (Object)Values.longValue((long)3L));
        Assert.assertEquals((Object)convertedMap.get("pageCacheMisses"), (Object)Values.longValue((long)2L));
        Assert.assertEquals((double)((DoubleValue)convertedMap.get("pageCacheHitRatio")).doubleValue(), (double)0.6, (double)1.0E-4);
        Assert.assertEquals((long)convertedMap.size(), (long)9L);
    }

    private Map<String, Object> getArguments() {
        return MapUtil.map((Object[])new Object[]{"argKey", "argValue"});
    }

    private Set<String> getIdentifiers() {
        return Iterators.asSet((Object[])new String[]{"identifier1", "identifier2"});
    }

    private TestProfilerStatistics getProfilerStatistics() {
        return new TestProfilerStatistics(1L, 2L, 3L, 2L);
    }

    private class TestProfilerStatistics
    implements ExecutionPlanDescription.ProfilerStatistics {
        private final long rows;
        private final long dbHits;
        private final long pageCacheHits;
        private final long pageCacheMisses;

        private TestProfilerStatistics(long rows, long dbHits, long pageCacheHits, long pageCacheMisses) {
            this.rows = rows;
            this.dbHits = dbHits;
            this.pageCacheHits = pageCacheHits;
            this.pageCacheMisses = pageCacheMisses;
        }

        public long getRows() {
            return this.rows;
        }

        public long getDbHits() {
            return this.dbHits;
        }

        public long getPageCacheHits() {
            return this.pageCacheHits;
        }

        public long getPageCacheMisses() {
            return this.pageCacheMisses;
        }
    }

    private class TestExecutionPlanDescription
    implements ExecutionPlanDescription {
        private final String name;
        private final ExecutionPlanDescription.ProfilerStatistics profilerStatistics;
        private final Set<String> identifiers;
        private final Map<String, Object> arguments;

        TestExecutionPlanDescription(String name, ExecutionPlanDescription.ProfilerStatistics profilerStatistics, Set<String> identifiers, Map<String, Object> arguments) {
            this.name = name;
            this.profilerStatistics = profilerStatistics;
            this.identifiers = identifiers;
            this.arguments = arguments;
        }

        public String getName() {
            return this.name;
        }

        public List<ExecutionPlanDescription> getChildren() {
            return Collections.emptyList();
        }

        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        public Set<String> getIdentifiers() {
            return this.identifiers;
        }

        public boolean hasProfilerStatistics() {
            return this.profilerStatistics != null;
        }

        public ExecutionPlanDescription.ProfilerStatistics getProfilerStatistics() {
            return this.profilerStatistics;
        }
    }
}

