/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.UUID;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.ErrorReporter;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

public class ErrorReporterTest {
    @Test
    public void onlyDatabaseErrorsAreLogged() {
        AssertableLogProvider userLog = new AssertableLogProvider();
        AssertableLogProvider internalLog = new AssertableLogProvider();
        ErrorReporter reporter = ErrorReporterTest.newErrorReporter((LogProvider)userLog, (LogProvider)internalLog);
        for (Status.Classification classification : Status.Classification.values()) {
            if (classification == Status.Classification.DatabaseError) continue;
            Status.Code code = ErrorReporterTest.newStatusCode(classification);
            Neo4jError error = Neo4jError.from(() -> code, (String)"Database error");
            reporter.report(error);
            userLog.assertNoLoggingOccurred();
            internalLog.assertNoLoggingOccurred();
        }
    }

    @Test
    public void databaseErrorShouldLogFullMessageInDebugLogAndHelpfulPointerInUserLog() {
        AssertableLogProvider userLog = new AssertableLogProvider();
        AssertableLogProvider internalLog = new AssertableLogProvider();
        ErrorReporter reporter = ErrorReporterTest.newErrorReporter((LogProvider)userLog, (LogProvider)internalLog);
        Neo4jError error = Neo4jError.fatalFrom((Throwable)new TestDatabaseError());
        UUID reference = error.reference();
        reporter.report(error);
        userLog.assertContainsLogCallContaining("Client triggered an unexpected error");
        userLog.assertContainsLogCallContaining(reference.toString());
        userLog.assertContainsLogCallContaining("Database error");
        internalLog.assertContainsLogCallContaining(reference.toString());
        internalLog.assertContainsLogCallContaining("Database error");
    }

    private static ErrorReporter newErrorReporter(LogProvider userLog, LogProvider internalLog) {
        return new ErrorReporter(userLog.getLog("userLog"), internalLog.getLog("internalLog"));
    }

    private static Status.Code newStatusCode(Status.Classification classification) {
        Status.Code code = (Status.Code)Mockito.mock(Status.Code.class);
        Mockito.when((Object)code.classification()).thenReturn((Object)classification);
        return code;
    }

    private static class TestDatabaseError
    extends RuntimeException
    implements Status.HasStatus {
        TestDatabaseError() {
            super("Database error");
        }

        public Status status() {
            return () -> ErrorReporterTest.newStatusCode(Status.Classification.DatabaseError);
        }
    }
}

