/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.BoltStateMachineState;
import org.neo4j.bolt.runtime.MutableConnectionState;
import org.neo4j.bolt.runtime.StateMachineContext;
import org.neo4j.bolt.security.auth.AuthenticationResult;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.InterruptSignal;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.runtime.ConnectedState;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;

class ConnectedStateTest {
    private static final String USER_AGENT = "Driver 2.0";
    private static final Map<String, Object> AUTH_TOKEN = AuthToken.newBasicAuthToken((String)"neo4j", (String)"password");
    private static final InitMessage INIT_MESSAGE = new InitMessage("Driver 2.0", AUTH_TOKEN);
    private final ConnectedState state = new ConnectedState();
    private final BoltStateMachineState readyState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final BoltStateMachineState failedState = (BoltStateMachineState)Mockito.mock(BoltStateMachineState.class);
    private final StateMachineContext context = (StateMachineContext)Mockito.mock(StateMachineContext.class);
    private final BoltStateMachineSPI boltSpi = (BoltStateMachineSPI)Mockito.mock(BoltStateMachineSPI.class, (Answer)Mockito.RETURNS_MOCKS);
    private final MutableConnectionState connectionState = new MutableConnectionState();

    ConnectedStateTest() {
    }

    @BeforeEach
    void setUp() {
        this.state.setReadyState(this.readyState);
        this.state.setFailedState(this.failedState);
        Mockito.when((Object)this.context.boltSpi()).thenReturn((Object)this.boltSpi);
        Mockito.when((Object)this.context.connectionState()).thenReturn((Object)this.connectionState);
    }

    @Test
    void shouldThrowWhenNotInitialized() throws Exception {
        ConnectedState state = new ConnectedState();
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)INIT_MESSAGE, this.context));
        state.setReadyState(this.readyState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)INIT_MESSAGE, this.context));
        state.setReadyState(null);
        state.setFailedState(this.failedState);
        Assertions.assertThrows(IllegalStateException.class, () -> state.process((RequestMessage)INIT_MESSAGE, this.context));
    }

    @Test
    void shouldAuthenticateOnInitMessage() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)INIT_MESSAGE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
        ((BoltStateMachineSPI)Mockito.verify((Object)this.boltSpi)).authenticate(AUTH_TOKEN);
    }

    @Test
    void shouldInitializeStatementProcessorOnInitMessage() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)INIT_MESSAGE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
        Assertions.assertNotNull((Object)this.connectionState.getStatementProcessor());
    }

    @Test
    void shouldAddMetadataOnExpiredCredentialsOnInitMessage() throws Exception {
        MutableConnectionState connectionStateMock = (MutableConnectionState)Mockito.mock(MutableConnectionState.class);
        Mockito.when((Object)this.context.connectionState()).thenReturn((Object)connectionStateMock);
        AuthenticationResult authResult = (AuthenticationResult)Mockito.mock(AuthenticationResult.class);
        Mockito.when((Object)authResult.credentialsExpired()).thenReturn((Object)true);
        Mockito.when((Object)authResult.getLoginContext()).thenReturn((Object)LoginContext.AUTH_DISABLED);
        Mockito.when((Object)this.boltSpi.authenticate(AUTH_TOKEN)).thenReturn((Object)authResult);
        BoltStateMachineState newState = this.state.process((RequestMessage)INIT_MESSAGE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
        ((MutableConnectionState)Mockito.verify((Object)connectionStateMock)).onMetadata("credentials_expired", (AnyValue)Values.TRUE);
    }

    @Test
    void shouldAddServerVersionMetadataOnInitMessage() throws Exception {
        Mockito.when((Object)this.boltSpi.version()).thenReturn((Object)"42.42.42");
        MutableConnectionState connectionStateMock = (MutableConnectionState)Mockito.mock(MutableConnectionState.class);
        Mockito.when((Object)this.context.connectionState()).thenReturn((Object)connectionStateMock);
        AuthenticationResult authResult = (AuthenticationResult)Mockito.mock(AuthenticationResult.class);
        Mockito.when((Object)authResult.credentialsExpired()).thenReturn((Object)true);
        Mockito.when((Object)authResult.getLoginContext()).thenReturn((Object)LoginContext.AUTH_DISABLED);
        Mockito.when((Object)this.boltSpi.authenticate(AUTH_TOKEN)).thenReturn((Object)authResult);
        BoltStateMachineState newState = this.state.process((RequestMessage)INIT_MESSAGE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
        ((MutableConnectionState)Mockito.verify((Object)connectionStateMock)).onMetadata("server", (AnyValue)Values.stringValue((String)"42.42.42"));
    }

    @Test
    void shouldRegisterClientInUDCOnInitMessage() throws Exception {
        BoltStateMachineState newState = this.state.process((RequestMessage)INIT_MESSAGE, this.context);
        Assertions.assertEquals((Object)this.readyState, (Object)newState);
        ((BoltStateMachineSPI)Mockito.verify((Object)this.boltSpi)).udcRegisterClient((String)ArgumentMatchers.eq((Object)USER_AGENT));
    }

    @Test
    void shouldHandleFailuresOnInitMessage() throws Exception {
        RuntimeException error = new RuntimeException("Hello");
        Mockito.when((Object)this.boltSpi.authenticate(AUTH_TOKEN)).thenThrow(new Throwable[]{error});
        BoltStateMachineState newState = this.state.process((RequestMessage)INIT_MESSAGE, this.context);
        Assertions.assertEquals((Object)this.failedState, (Object)newState);
        ((StateMachineContext)Mockito.verify((Object)this.context)).handleFailure((Throwable)error, true);
    }

    @Test
    void shouldNotProcessUnsupportedMessage() throws Exception {
        List<RequestMessage> unsupportedMessages = Arrays.asList(AckFailureMessage.INSTANCE, DiscardAllMessage.INSTANCE, InterruptSignal.INSTANCE, PullAllMessage.INSTANCE, ResetMessage.INSTANCE, new RunMessage("RETURN 1", VirtualValues.EMPTY_MAP));
        for (RequestMessage message : unsupportedMessages) {
            Assertions.assertNull((Object)this.state.process(message, this.context));
        }
    }
}

