/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnectionAuthFatality;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.runtime.TransactionStateMachineSPI;
import org.neo4j.bolt.testing.BoltMatchers;
import org.neo4j.bolt.testing.BoltResponseRecorder;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.runtime.BoltStateMachineV1;
import org.neo4j.bolt.v1.runtime.BoltStateMachineV1SPI;
import org.neo4j.bolt.v1.runtime.ConnectedState;
import org.neo4j.bolt.v1.runtime.FailedState;
import org.neo4j.bolt.v1.runtime.MachineRoom;
import org.neo4j.bolt.v1.runtime.ReadyState;
import org.neo4j.bolt.v1.runtime.TransactionStateMachine;
import org.neo4j.function.ThrowingBiConsumer;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.security.AuthorizationExpiredException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.virtual.VirtualValues;

public class BoltStateMachineTest {
    @Test
    public void allStateTransitionsShouldSendExactlyOneResponseToTheClient() throws Exception {
        List<RequestMessage> messages = Arrays.asList(new InitMessage("BoltStateMachineTest/0.0", Collections.emptyMap()), AckFailureMessage.INSTANCE, ResetMessage.INSTANCE, new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), DiscardAllMessage.INSTANCE, PullAllMessage.INSTANCE);
        for (RequestMessage message : messages) {
            BoltMatchers.verifyOneResponse((ThrowingBiConsumer<BoltStateMachine, BoltResponseRecorder, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, recorder) -> machine.process(message, (BoltResponseHandler)recorder)));
        }
    }

    @Test
    public void initialStateShouldBeConnected() {
        MatcherAssert.assertThat((Object)MachineRoom.newMachine(), BoltMatchers.inState(ConnectedState.class));
    }

    @Test
    public void shouldRollbackOpenTransactionOnReset() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachineWithTransaction();
        machine.markFailed(Neo4jError.from((Throwable)new RuntimeException()));
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.hasNoTransaction());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(ReadyState.class));
    }

    @Test
    public void shouldRollbackOpenTransactionOnClose() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachineWithTransaction();
        machine.close();
        MatcherAssert.assertThat((Object)machine, BoltMatchers.hasNoTransaction());
    }

    @Test
    public void shouldBeAbleToResetWhenInReadyState() throws Throwable {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.canReset());
    }

    @Test
    public void shouldResetWithOpenTransaction() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachineWithTransaction();
        MatcherAssert.assertThat((Object)machine, BoltMatchers.canReset());
    }

    @Test
    public void shouldResetWithOpenTransactionAndOpenResult() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachineWithTransaction();
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.canReset());
    }

    @Test
    public void shouldResetWithOpenResult() throws Throwable {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.canReset());
    }

    @Test
    public void shouldFailWhenOutOfOrderRollback() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine();
        machine.markFailed(Neo4jError.from((Throwable)new RuntimeException()));
        machine.process((RequestMessage)new RunMessage("ROLLBACK", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
    }

    @Test
    public void shouldGoBackToReadyAfterAckFailure() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachine();
        machine.markFailed(Neo4jError.from((Throwable)new RuntimeException()));
        machine.process((RequestMessage)AckFailureMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(ReadyState.class));
    }

    @Test
    public void shouldNotRollbackOpenTransactionOnAckFailure() throws Throwable {
        BoltStateMachine machine = MachineRoom.newMachineWithTransaction();
        machine.markFailed(Neo4jError.from((Throwable)new RuntimeException()));
        machine.process((RequestMessage)AckFailureMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.hasTransaction());
    }

    @Test
    public void shouldRemainStoppedAfterInterrupted() throws Throwable {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.close();
        MatcherAssert.assertThat((Object)machine, BoltMatchers.isClosed());
        machine.interrupt();
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.isClosed());
    }

    @Test
    public void shouldBeAbleToKillMessagesAheadInLineWithAnInterrupt() throws Throwable {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.interrupt();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)recorder);
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)recorder);
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void multipleInterruptsShouldBeMatchedWithMultipleResets() throws Throwable {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.interrupt();
        machine.interrupt();
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)recorder);
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)recorder);
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.wasIgnored());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.wasIgnored());
        recorder.reset();
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)recorder);
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void testPublishingError() throws Throwable {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltResponseRecorder recorder = new BoltResponseRecorder(){

            @Override
            public void onRecords(BoltResult result, boolean pull) {
                throw new RuntimeException("I've been expecting you, Mr Bond.");
            }
        };
        machine.process((RequestMessage)PullAllMessage.INSTANCE, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.failedWithStatus((Status)Status.General.UnknownError));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
    }

    @Test
    public void testRollbackError() throws Throwable {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.process((RequestMessage)new RunMessage("BEGIN", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)DiscardAllMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        TransactionStateMachine txMachine = BoltStateMachineTest.txStateMachine(machine);
        Mockito.when((Object)txMachine.ctx.currentTransaction.isOpen()).thenReturn((Object)true);
        ((KernelTransaction)Mockito.doThrow((Throwable[])new Throwable[]{new TransactionFailureException("No Mr. Bond, I expect you to die.")}).when((Object)txMachine.ctx.currentTransaction)).close();
        machine.process((RequestMessage)new RunMessage("ROLLBACK", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)DiscardAllMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
    }

    @Test
    public void testFailOnNestedTransactions() throws Throwable {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.process((RequestMessage)new RunMessage("BEGIN", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)DiscardAllMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)new RunMessage("BEGIN", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process((RequestMessage)DiscardAllMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
    }

    @Test
    public void testCantDoAnythingIfInFailedState() throws Throwable {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.markFailed(Neo4jError.from((Throwable)new RuntimeException()));
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
        machine.process((RequestMessage)DiscardAllMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
        machine.process((RequestMessage)PullAllMessage.INSTANCE, (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
    }

    @Test
    public void testUsingResetToAcknowledgeError() throws Throwable {
        BoltResponseRecorder recorder = new BoltResponseRecorder();
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.markFailed(Neo4jError.from((Throwable)new RuntimeException()));
        machine.process((RequestMessage)ResetMessage.INSTANCE, (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)recorder);
        MatcherAssert.assertThat((Object)recorder.nextResponse(), BoltMatchers.succeeded());
    }

    @Test
    public void actionsDisallowedBeforeInitialized() {
        BoltStateMachine machine = MachineRoom.newMachine();
        try {
            machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
            Assert.fail((String)"Failed to fail fatally");
        }
        catch (BoltConnectionFatality boltConnectionFatality) {
            // empty catch block
        }
    }

    @Test
    public void shouldTerminateOnAuthExpiryDuringREADYRun() throws Throwable {
        TransactionStateMachineSPI transactionSPI = (TransactionStateMachineSPI)Mockito.mock(TransactionStateMachineSPI.class);
        ((TransactionStateMachineSPI)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationExpiredException("Auth expired!")}).when((Object)transactionSPI)).beginTransaction((LoginContext)ArgumentMatchers.any(), (Duration)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        BoltStateMachine machine = MachineRoom.newMachineWithTransactionSPI(transactionSPI);
        try {
            machine.process((RequestMessage)new RunMessage("THIS WILL BE IGNORED", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
            Assert.fail((String)"Exception expected");
        }
        catch (BoltConnectionAuthFatality e) {
            Assert.assertEquals((Object)"Auth expired!", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void shouldTerminateOnAuthExpiryDuringSTREAMINGPullAll() throws Throwable {
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        ((BoltResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationExpiredException("Auth expired!")}).when((Object)responseHandler)).onRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltStateMachineTest.txStateMachine((BoltStateMachine)machine).ctx.currentResult = BoltResult.EMPTY;
        try {
            machine.process((RequestMessage)PullAllMessage.INSTANCE, responseHandler);
            Assert.fail((String)"Exception expected");
        }
        catch (BoltConnectionAuthFatality e) {
            Assert.assertEquals((Object)"Auth expired!", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void shouldTerminateOnAuthExpiryDuringSTREAMINGDiscardAll() throws Throwable {
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        ((BoltResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationExpiredException("Auth expired!")}).when((Object)responseHandler)).onRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.process((RequestMessage)new RunMessage("RETURN 1", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltStateMachineTest.txStateMachine((BoltStateMachine)machine).ctx.currentResult = BoltResult.EMPTY;
        try {
            machine.process((RequestMessage)DiscardAllMessage.INSTANCE, responseHandler);
            Assert.fail((String)"Exception expected");
        }
        catch (BoltConnectionAuthFatality e) {
            Assert.assertEquals((Object)"Auth expired!", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void callResetEvenThoughAlreadyClosed() throws Throwable {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        TransactionStateMachine statementProcessor = BoltStateMachineTest.txStateMachine(machine);
        machine.close();
        MatcherAssert.assertThat((Object)statementProcessor.ctx.currentTransaction, (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)machine, BoltMatchers.isClosed());
        statementProcessor.run("RETURN 1", MachineRoom.EMPTY_PARAMS);
        MatcherAssert.assertThat((Object)statementProcessor.ctx.currentTransaction, (Matcher)CoreMatchers.notNullValue());
        machine.close();
        MatcherAssert.assertThat((Object)statementProcessor.ctx.currentTransaction, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldCloseBoltChannelWhenClosed() {
        BoltStateMachineV1SPI spi = (BoltStateMachineV1SPI)Mockito.mock(BoltStateMachineV1SPI.class);
        BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
        BoltStateMachineV1 machine = new BoltStateMachineV1((BoltStateMachineSPI)spi, boltChannel, Clock.systemUTC());
        machine.close();
        ((BoltChannel)Mockito.verify((Object)boltChannel)).close();
    }

    @Test
    public void shouldSetPendingErrorOnMarkFailedIfNoHandler() {
        BoltStateMachineV1SPI spi = (BoltStateMachineV1SPI)Mockito.mock(BoltStateMachineV1SPI.class);
        BoltChannel boltChannel = (BoltChannel)Mockito.mock(BoltChannel.class);
        BoltStateMachineV1 machine = new BoltStateMachineV1((BoltStateMachineSPI)spi, boltChannel, Clock.systemUTC());
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.markFailed(error);
        Assert.assertEquals((Object)error, (Object)BoltStateMachineTest.pendingError((BoltStateMachine)machine));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextInitMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.process((RequestMessage)new InitMessage("Test/1.0", Collections.emptyMap()), handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextRunMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.process((RequestMessage)new RunMessage("RETURN 1", VirtualValues.EMPTY_MAP), handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextPullAllMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.process((RequestMessage)PullAllMessage.INSTANCE, handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextDiscardAllMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.process((RequestMessage)DiscardAllMessage.INSTANCE, handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextResetMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachine machine = MachineRoom.newMachine();
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.markFailed(error);
        machine.process((RequestMessage)ResetMessage.INSTANCE, responseHandler);
        Assert.assertNull((Object)BoltStateMachineTest.pendingError(machine));
        Assert.assertFalse((boolean)BoltStateMachineTest.pendingIgnore(machine));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(ReadyState.class));
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler, (VerificationMode)Mockito.never())).markFailed((Neo4jError)ArgumentMatchers.any());
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler, (VerificationMode)Mockito.never())).markIgnored();
    }

    @Test
    public void shouldGotoReadyStateOnNextAckFailureMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachine machine = MachineRoom.newMachine();
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.markFailed(error);
        machine.process((RequestMessage)AckFailureMessage.INSTANCE, responseHandler);
        Assert.assertNull((Object)BoltStateMachineTest.pendingError(machine));
        Assert.assertFalse((boolean)BoltStateMachineTest.pendingIgnore(machine));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(ReadyState.class));
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler, (VerificationMode)Mockito.never())).markFailed((Neo4jError)ArgumentMatchers.any());
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler, (VerificationMode)Mockito.never())).markIgnored();
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextExternalErrorMessageOnMarkFailedIfNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedOnNextMessage((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.handleExternalFailure(Neo4jError.from((Status)Status.Request.Invalid, (String)"invalid"), handler)));
    }

    @Test
    public void shouldSetPendingIgnoreOnMarkFailedIfAlreadyFailedAndNoHandler() throws Exception {
        BoltStateMachine machine = MachineRoom.newMachine();
        Neo4jError error1 = Neo4jError.from((Throwable)new RuntimeException());
        machine.markFailed(error1);
        Neo4jError error2 = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.markFailed(error2);
        Assert.assertTrue((boolean)BoltStateMachineTest.pendingIgnore(machine));
        Assert.assertEquals((Object)error1, (Object)BoltStateMachineTest.pendingError(machine));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextInitMessageOnMarkFailedIfAlreadyFailedAndNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedShouldYieldIgnoredIfAlreadyFailed((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.process((RequestMessage)new InitMessage("Test/1.0", Collections.emptyMap()), handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextRunMessageOnMarkFailedIfAlreadyFailedAndNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedShouldYieldIgnoredIfAlreadyFailed((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.process((RequestMessage)new RunMessage("RETURN 1", VirtualValues.EMPTY_MAP), handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextPullAllMessageOnMarkFailedIfAlreadyFailedAndNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedShouldYieldIgnoredIfAlreadyFailed((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.process((RequestMessage)PullAllMessage.INSTANCE, handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextDiscardAllMessageOnMarkFailedIfAlreadyFailedAndNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedShouldYieldIgnoredIfAlreadyFailed((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.process((RequestMessage)DiscardAllMessage.INSTANCE, handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextResetMessageOnMarkFailedIfAlreadyFailedAndNoHandler() throws Exception {
        BoltStateMachine machine = MachineRoom.newMachine();
        machine.markFailed(Neo4jError.from((Throwable)new RuntimeException()));
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.markFailed(error);
        machine.process((RequestMessage)ResetMessage.INSTANCE, responseHandler);
        Assert.assertNull((Object)BoltStateMachineTest.pendingError(machine));
        Assert.assertFalse((boolean)BoltStateMachineTest.pendingIgnore(machine));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(ReadyState.class));
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler, (VerificationMode)Mockito.never())).markIgnored();
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler, (VerificationMode)Mockito.never())).markFailed((Neo4jError)ArgumentMatchers.any());
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextAckFailureMessageOnMarkFailedIfAlreadyFailedAndNoHandler() throws Exception {
        BoltStateMachine machine = MachineRoom.newMachine();
        machine.markFailed(Neo4jError.from((Throwable)new RuntimeException()));
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.markFailed(error);
        machine.process((RequestMessage)AckFailureMessage.INSTANCE, responseHandler);
        Assert.assertNull((Object)BoltStateMachineTest.pendingError(machine));
        Assert.assertFalse((boolean)BoltStateMachineTest.pendingIgnore(machine));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(ReadyState.class));
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler, (VerificationMode)Mockito.never())).markIgnored();
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler, (VerificationMode)Mockito.never())).markFailed((Neo4jError)ArgumentMatchers.any());
    }

    @Test
    public void shouldInvokeResponseHandlerOnNextExternalErrorMessageOnMarkFailedIfAlreadyFailedAndNoHandler() throws Exception {
        BoltStateMachineTest.testMarkFailedShouldYieldIgnoredIfAlreadyFailed((ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality>)((ThrowingBiConsumer)(machine, handler) -> machine.handleExternalFailure(Neo4jError.from((Status)Status.Request.Invalid, (String)"invalid"), handler)));
    }

    @Test
    public void shouldInvokeResponseHandlerOnMarkFailedIfThereIsHandler() throws Exception {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        ((BoltStateMachineV1)machine).connectionState().setResponseHandler(responseHandler);
        machine.markFailed(error);
        Assert.assertNull((Object)BoltStateMachineTest.pendingError(machine));
        Assert.assertFalse((boolean)BoltStateMachineTest.pendingIgnore(machine));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler)).markFailed(error);
    }

    @Test
    public void shouldNotFailWhenMarkedForTerminationAndPullAll() throws Exception {
        BoltStateMachineV1SPI spi = (BoltStateMachineV1SPI)Mockito.mock(BoltStateMachineV1SPI.class, (Answer)Mockito.RETURNS_MOCKS);
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine(spi));
        machine.process((RequestMessage)new RunMessage("RETURN 42", MachineRoom.EMPTY_PARAMS), (BoltResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltStateMachineTest.txStateMachine((BoltStateMachine)machine).ctx.currentResult = BoltResult.EMPTY;
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        machine.markForTermination();
        machine.process((RequestMessage)PullAllMessage.INSTANCE, responseHandler);
        ((BoltStateMachineV1SPI)Mockito.verify((Object)spi, (VerificationMode)Mockito.never())).reportError((Neo4jError)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)machine, (Matcher)Matchers.not(BoltMatchers.inState(FailedState.class)));
    }

    private static void testMarkFailedOnNextMessage(ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality> action) throws Exception {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.markFailed(error);
        action.accept((Object)machine, (Object)responseHandler);
        Assert.assertNull((Object)BoltStateMachineTest.pendingError(machine));
        Assert.assertFalse((boolean)BoltStateMachineTest.pendingIgnore(machine));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler)).markFailed(error);
    }

    private static void testMarkFailedShouldYieldIgnoredIfAlreadyFailed(ThrowingBiConsumer<BoltStateMachine, BoltResponseHandler, BoltConnectionFatality> action) throws Exception {
        BoltStateMachine machine = MachineRoom.init(MachineRoom.newMachine());
        machine.markFailed(Neo4jError.from((Throwable)new RuntimeException()));
        BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
        Neo4jError error = Neo4jError.from((Status)Status.Request.NoThreadsAvailable, (String)"no threads");
        machine.markFailed(error);
        action.accept((Object)machine, (Object)responseHandler);
        Assert.assertNull((Object)BoltStateMachineTest.pendingError(machine));
        Assert.assertFalse((boolean)BoltStateMachineTest.pendingIgnore(machine));
        MatcherAssert.assertThat((Object)machine, BoltMatchers.inState(FailedState.class));
        ((BoltResponseHandler)Mockito.verify((Object)responseHandler)).markIgnored();
    }

    private static TransactionStateMachine txStateMachine(BoltStateMachine machine) {
        return (TransactionStateMachine)((BoltStateMachineV1)machine).statementProcessor();
    }

    private static Neo4jError pendingError(BoltStateMachine machine) {
        return ((BoltStateMachineV1)machine).connectionState().getPendingError();
    }

    private static boolean pendingIgnore(BoltStateMachine machine) {
        return ((BoltStateMachineV1)machine).connectionState().hasPendingIgnore();
    }
}

