/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineFactoryImpl;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.testing.BoltTestUtil;
import org.neo4j.bolt.v1.runtime.BoltStateMachineV1;
import org.neo4j.bolt.v3.BoltStateMachineV3;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.udc.UsageData;

class BoltStateMachineFactoryImplTest {
    private static final String CUSTOM_DB_NAME = "customDbName";
    private static final Clock CLOCK = Clock.systemUTC();
    private static final BoltChannel CHANNEL = BoltTestUtil.newTestBoltChannel();

    BoltStateMachineFactoryImplTest() {
    }

    @ParameterizedTest(name="V{0}")
    @ValueSource(longs={1L, 2L})
    void shouldCreateBoltStateMachinesV1(long protocolVersion) {
        BoltStateMachineFactoryImpl factory = BoltStateMachineFactoryImplTest.newBoltFactory();
        BoltStateMachine boltStateMachine = factory.newStateMachine(protocolVersion, CHANNEL);
        Assert.assertNotNull((Object)boltStateMachine);
        Assert.assertThat((Object)boltStateMachine, (Matcher)CoreMatchers.instanceOf(BoltStateMachineV1.class));
    }

    @Test
    void shouldCreateBoltStateMachinesV3() {
        BoltStateMachineFactoryImpl factory = BoltStateMachineFactoryImplTest.newBoltFactory();
        BoltStateMachine boltStateMachine = factory.newStateMachine(3L, CHANNEL);
        Assert.assertNotNull((Object)boltStateMachine);
        Assert.assertThat((Object)boltStateMachine, (Matcher)CoreMatchers.instanceOf(BoltStateMachineV3.class));
    }

    @ParameterizedTest(name="V{0}")
    @ValueSource(longs={999L, -1L})
    void shouldThrowExceptionIfVersionIsUnknown(long protocolVersion) {
        BoltStateMachineFactoryImpl factory = BoltStateMachineFactoryImplTest.newBoltFactory();
        IllegalArgumentException error = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> factory.newStateMachine(protocolVersion, CHANNEL));
        Assert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Failed to create a state machine for protocol version"));
    }

    private static BoltStateMachineFactoryImpl newBoltFactory() {
        return BoltStateMachineFactoryImplTest.newBoltFactory(BoltStateMachineFactoryImplTest.newDbMock());
    }

    private static BoltStateMachineFactoryImpl newBoltFactory(DatabaseManager databaseManager) {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.active_database, (String)CUSTOM_DB_NAME);
        return new BoltStateMachineFactoryImpl(databaseManager, new UsageData((JobScheduler)new OnDemandJobScheduler()), (Authentication)Mockito.mock(Authentication.class), CLOCK, config, (LogService)NullLogService.getInstance());
    }

    private static DatabaseManager newDbMock() {
        GraphDatabaseFacade db = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)db.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        GraphDatabaseQueryService queryService = (GraphDatabaseQueryService)Mockito.mock(GraphDatabaseQueryService.class);
        Mockito.when((Object)queryService.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)dependencyResolver.resolveDependency(GraphDatabaseQueryService.class)).thenReturn((Object)queryService);
        DatabaseManager databaseManager = (DatabaseManager)Mockito.mock(DatabaseManager.class);
        Mockito.when((Object)databaseManager.getDatabaseFacade(CUSTOM_DB_NAME)).thenReturn(Optional.of(db));
        return databaseManager;
    }
}

