/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.packstream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.packstream.BufferedChannelInput;
import org.neo4j.bolt.v1.packstream.BufferedChannelOutput;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.packstream.PackType;

public class PackStreamTest {
    public static Map<String, Object> asMap(Object ... keysAndValues) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(keysAndValues.length / 2);
        String key = null;
        for (Object keyOrValue : keysAndValues) {
            if (key == null) {
                key = keyOrValue.toString();
                continue;
            }
            map.put(key, keyOrValue);
            key = null;
        }
        return map;
    }

    private PackStream.Unpacker newUnpacker(byte[] bytes) {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return new PackStream.Unpacker((PackInput)new BufferedChannelInput(16).reset(Channels.newChannel(input)));
    }

    @Test
    public void testCanPackAndUnpackNull() throws Throwable {
        Machine machine = new Machine();
        machine.packer().packNull();
        machine.packer().flush();
        byte[] bytes = machine.output();
        MatcherAssert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)new byte[]{-64}));
        PackStream.Unpacker unpacker = this.newUnpacker(bytes);
        unpacker.unpackNull();
    }

    @Test
    public void testCanPackAndUnpackTrue() throws Throwable {
        Machine machine = new Machine();
        machine.packer().pack(true);
        machine.packer().flush();
        byte[] bytes = machine.output();
        MatcherAssert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)new byte[]{-61}));
        PackStream.Unpacker unpacker = this.newUnpacker(bytes);
        MatcherAssert.assertThat((Object)unpacker.unpackBoolean(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testCanPackAndUnpackFalse() throws Throwable {
        Machine machine = new Machine();
        machine.packer().pack(false);
        machine.packer().flush();
        byte[] bytes = machine.output();
        MatcherAssert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)new byte[]{-62}));
        PackStream.Unpacker unpacker = this.newUnpacker(bytes);
        MatcherAssert.assertThat((Object)unpacker.unpackBoolean(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testCanPackAndUnpackTinyIntegers() throws Throwable {
        Machine machine = new Machine();
        for (long i = -16L; i < 128L; ++i) {
            machine.reset();
            machine.packer().pack(i);
            machine.packer().flush();
            byte[] bytes = machine.output();
            MatcherAssert.assertThat((Object)bytes.length, (Matcher)CoreMatchers.equalTo((Object)1));
            PackStream.Unpacker unpacker = this.newUnpacker(bytes);
            MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)i));
        }
    }

    @Test
    public void testCanPackAndUnpackShortIntegers() throws Throwable {
        Machine machine = new Machine();
        for (long i = -32768L; i < 32768L; ++i) {
            machine.reset();
            machine.packer().pack(i);
            machine.packer().flush();
            byte[] bytes = machine.output();
            MatcherAssert.assertThat((Object)bytes.length, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(3)));
            PackStream.Unpacker unpacker = this.newUnpacker(bytes);
            MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)i));
        }
    }

    @Test
    public void testCanPackAndUnpackPowersOfTwoAsIntegers() throws Throwable {
        Machine machine = new Machine();
        for (int i = 0; i < 32; ++i) {
            long n = (long)Math.pow(2.0, i);
            machine.reset();
            machine.packer().pack(n);
            machine.packer().flush();
            long value = this.newUnpacker(machine.output()).unpackLong();
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)n));
        }
    }

    @Test
    public void testCanPackAndUnpackPowersOfTwoPlusABitAsDoubles() throws Throwable {
        Machine machine = new Machine();
        for (int i = 0; i < 32; ++i) {
            double n = Math.pow(2.0, i) + 0.5;
            machine.reset();
            machine.packer().pack(n);
            machine.packer().flush();
            double value = this.newUnpacker(machine.output()).unpackDouble();
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)n));
        }
    }

    @Test
    public void testCanPackAndUnpackPowersOfTwoMinusABitAsDoubles() throws Throwable {
        Machine machine = new Machine();
        for (int i = 0; i < 32; ++i) {
            double n = Math.pow(2.0, i) - 0.5;
            machine.reset();
            machine.packer().pack(n);
            machine.packer().flush();
            double value = this.newUnpacker(machine.output()).unpackDouble();
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)n));
        }
    }

    @Test
    public void testCanPackCommonlyUsedCharAndUnpackAsString() throws Throwable {
        Machine machine = new Machine();
        for (int i = 32; i < 127; ++i) {
            char c = (char)i;
            machine.reset();
            machine.packer().pack(c);
            machine.packer().flush();
            String value = this.newUnpacker(machine.output()).unpackString();
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)String.valueOf(c)));
        }
    }

    @Test
    public void testCanPackRandomCharAndUnpackAsString() throws Throwable {
        char[] chars;
        Machine machine = new Machine();
        for (char c : chars = new char[]{'\u00f8', '\u00e5', '\u00b4', '\u2020', '\u0153', '\u2248'}) {
            machine.reset();
            machine.packer().pack(c);
            machine.packer().flush();
            String value = this.newUnpacker(machine.output()).unpackString();
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)String.valueOf(c)));
        }
    }

    @Test
    public void testCanPackAndUnpackStrings() throws Throwable {
        Machine machine = new Machine(17000000);
        for (int i = 0; i < 24; ++i) {
            String string = new String(new byte[(int)Math.pow(2.0, i)]);
            machine.reset();
            machine.packer().pack(string);
            machine.packer().flush();
            String value = this.newUnpacker(machine.output()).unpackString();
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)string));
        }
    }

    @Test
    public void testCanPackAndUnpackBytes() throws Throwable {
        Machine machine = new Machine();
        byte[] abcdefghij = "ABCDEFGHIJ".getBytes();
        PackStream.Packer packer = machine.packer();
        packer.pack(abcdefghij);
        packer.flush();
        byte[] value = this.newUnpacker(machine.output()).unpackBytes();
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)abcdefghij));
    }

    @Test
    public void testCanPackAndUnpackString() throws Throwable {
        Machine machine = new Machine();
        String abcdefghij = "ABCDEFGHIJ";
        PackStream.Packer packer = machine.packer();
        packer.pack(abcdefghij);
        packer.flush();
        String value = this.newUnpacker(machine.output()).unpackString();
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)abcdefghij));
    }

    @Test
    public void testCanPackAndUnpackListInOneCall() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packListHeader(3);
        packer.pack(12L);
        packer.pack(13L);
        packer.pack(14L);
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        MatcherAssert.assertThat((Object)unpacker.unpackListHeader(), (Matcher)CoreMatchers.equalTo((Object)3L));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)12L));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)13L));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)14L));
    }

    @Test
    public void testCanPackAndUnpackListOneItemAtATime() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packListHeader(3);
        packer.pack(12L);
        packer.pack(13L);
        packer.pack(14L);
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        MatcherAssert.assertThat((Object)unpacker.unpackListHeader(), (Matcher)CoreMatchers.equalTo((Object)3L));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)12L));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)13L));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)14L));
    }

    @Test
    public void testCanPackAndUnpackListOfString() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packListHeader(3);
        packer.flush();
        packer.pack("eins");
        packer.flush();
        packer.pack("zwei");
        packer.flush();
        packer.pack("drei");
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        MatcherAssert.assertThat((Object)unpacker.unpackListHeader(), (Matcher)CoreMatchers.equalTo((Object)3L));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"eins"));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"zwei"));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"drei"));
    }

    @Test
    public void testCanPackAndUnpackListStream() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packListStreamHeader();
        packer.pack("eins");
        packer.pack("zwei");
        packer.pack("drei");
        packer.packEndOfStream();
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        MatcherAssert.assertThat((Object)unpacker.unpackListHeader(), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"eins"));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"zwei"));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"drei"));
        unpacker.unpackEndOfStream();
    }

    @Test
    public void testCanPackAndUnpackMap() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packMapHeader(2);
        packer.pack("one");
        packer.pack(1L);
        packer.pack("two");
        packer.pack(2L);
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        MatcherAssert.assertThat((Object)unpacker.unpackMapHeader(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"one"));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"two"));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    @Test
    public void testCanPackAndUnpackMapStream() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packMapStreamHeader();
        packer.pack("one");
        packer.pack(1L);
        packer.pack("two");
        packer.pack(2L);
        packer.packEndOfStream();
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        MatcherAssert.assertThat((Object)unpacker.unpackMapHeader(), (Matcher)CoreMatchers.equalTo((Object)-1L));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"one"));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"two"));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)2L));
        unpacker.unpackEndOfStream();
    }

    @Test
    public void testCanPackAndUnpackStruct() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packStructHeader(3, (byte)78);
        packer.pack(12L);
        packer.packListHeader(2);
        packer.pack("Person");
        packer.pack("Employee");
        packer.packMapHeader(2);
        packer.pack("name");
        packer.pack("Alice");
        packer.pack("age");
        packer.pack(33L);
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        MatcherAssert.assertThat((Object)unpacker.unpackStructHeader(), (Matcher)CoreMatchers.equalTo((Object)3L));
        MatcherAssert.assertThat((Object)Character.valueOf(unpacker.unpackStructSignature()), (Matcher)CoreMatchers.equalTo((Object)Character.valueOf('N')));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)12L));
        MatcherAssert.assertThat((Object)unpacker.unpackListHeader(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"Person"));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"Employee"));
        MatcherAssert.assertThat((Object)unpacker.unpackMapHeader(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"name"));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"Alice"));
        MatcherAssert.assertThat((Object)unpacker.unpackString(), (Matcher)CoreMatchers.equalTo((Object)"age"));
        MatcherAssert.assertThat((Object)unpacker.unpackLong(), (Matcher)CoreMatchers.equalTo((Object)33L));
    }

    @Test
    public void testCanPackStructIncludingSignature() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packStructHeader(3, (byte)78);
        packer.pack(12L);
        packer.packListHeader(2);
        packer.pack("Person");
        packer.pack("Employee");
        packer.packMapHeader(2);
        packer.pack("name");
        packer.pack("Alice");
        packer.pack("age");
        packer.pack(33L);
        packer.flush();
        byte[] bytes = machine.output();
        byte[] expected = new byte[]{-77, 78, 12, -110, -122, 80, 101, 114, 115, 111, 110, -120, 69, 109, 112, 108, 111, 121, 101, 101, -94, -124, 110, 97, 109, 101, -123, 65, 108, 105, 99, 101, -125, 97, 103, 101, 33};
        MatcherAssert.assertThat((Object)bytes, (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testCanDoStreamingListUnpacking() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packListHeader(4);
        packer.pack(1L);
        packer.pack(2L);
        packer.pack(3L);
        packer.packListHeader(2);
        packer.pack(4L);
        packer.pack(5L);
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        long size = unpacker.unpackListHeader();
        long a = unpacker.unpackLong();
        long b = unpacker.unpackLong();
        long c = unpacker.unpackLong();
        long innerSize = unpacker.unpackListHeader();
        long d = unpacker.unpackLong();
        long e = unpacker.unpackLong();
        Assert.assertEquals((long)4L, (long)size);
        Assert.assertEquals((long)2L, (long)innerSize);
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((long)2L, (long)b);
        Assert.assertEquals((long)3L, (long)c);
        Assert.assertEquals((long)4L, (long)d);
        Assert.assertEquals((long)5L, (long)e);
    }

    @Test
    public void testCanDoStreamingStructUnpacking() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packStructHeader(4, (byte)126);
        packer.pack(1L);
        packer.pack(2L);
        packer.pack(3L);
        packer.packListHeader(2);
        packer.pack(4L);
        packer.pack(5L);
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        long size = unpacker.unpackStructHeader();
        char signature = unpacker.unpackStructSignature();
        long a = unpacker.unpackLong();
        long b = unpacker.unpackLong();
        long c = unpacker.unpackLong();
        long innerSize = unpacker.unpackListHeader();
        long d = unpacker.unpackLong();
        long e = unpacker.unpackLong();
        Assert.assertEquals((long)4L, (long)size);
        Assert.assertEquals((long)126L, (long)signature);
        Assert.assertEquals((long)2L, (long)innerSize);
        Assert.assertEquals((long)1L, (long)a);
        Assert.assertEquals((long)2L, (long)b);
        Assert.assertEquals((long)3L, (long)c);
        Assert.assertEquals((long)4L, (long)d);
        Assert.assertEquals((long)5L, (long)e);
    }

    @Test
    public void testCanDoStreamingMapUnpacking() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.packMapHeader(2);
        packer.pack("name");
        packer.pack("Bob");
        packer.pack("cat_ages");
        packer.packListHeader(2);
        packer.pack(4.3);
        packer.pack(true);
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        long size = unpacker.unpackMapHeader();
        String k1 = unpacker.unpackString();
        String v1 = unpacker.unpackString();
        String k2 = unpacker.unpackString();
        long innerSize = unpacker.unpackListHeader();
        double d = unpacker.unpackDouble();
        boolean e = unpacker.unpackBoolean();
        Assert.assertEquals((long)2L, (long)size);
        Assert.assertEquals((long)2L, (long)innerSize);
        Assert.assertEquals((Object)"name", (Object)k1);
        Assert.assertEquals((Object)"Bob", (Object)v1);
        Assert.assertEquals((Object)"cat_ages", (Object)k2);
        Assert.assertEquals((double)4.3, (double)d, (double)1.0E-4);
        Assert.assertTrue((boolean)e);
    }

    @Test
    public void handlesDataCrossingBufferBoundaries() throws Throwable {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        packer.pack(Long.MAX_VALUE);
        packer.pack(Long.MAX_VALUE);
        packer.flush();
        ReadableByteChannel ch = Channels.newChannel(new ByteArrayInputStream(machine.output()));
        PackStream.Unpacker unpacker = new PackStream.Unpacker((PackInput)new BufferedChannelInput(11).reset(ch));
        long first = unpacker.unpackLong();
        long second = unpacker.unpackLong();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)first);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)second);
    }

    @Test
    public void testCanPeekOnNextType() throws Throwable {
        this.assertPeekType(PackType.STRING, "a string");
        this.assertPeekType(PackType.INTEGER, 123L);
        this.assertPeekType(PackType.FLOAT, 123.123);
        this.assertPeekType(PackType.BOOLEAN, true);
        this.assertPeekType(PackType.LIST, Arrays.asList(1, 2, 3));
        this.assertPeekType(PackType.MAP, PackStreamTest.asMap("l", 3));
    }

    private void assertPeekType(PackType type, Object value) throws IOException {
        Machine machine = new Machine();
        PackStream.Packer packer = machine.packer();
        this.doTheThing(packer, value);
        packer.flush();
        PackStream.Unpacker unpacker = this.newUnpacker(machine.output());
        Assert.assertEquals((Object)type, (Object)unpacker.peekNextType());
    }

    private void doTheThing(PackStream.Packer packer, Object value) throws IOException {
        block3: {
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                if (!(value instanceof String)) break block2;
                                packer.pack((String)value);
                                break block3;
                            }
                            if (!(value instanceof Long) && !(value instanceof Integer)) break block4;
                            packer.pack(((Number)value).longValue());
                            break block3;
                        }
                        if (!(value instanceof Double) && !(value instanceof Float)) break block5;
                        packer.pack(((Number)value).doubleValue());
                        break block3;
                    }
                    if (!(value instanceof Boolean)) break block6;
                    packer.pack(((Boolean)value).booleanValue());
                    break block3;
                }
                if (!(value instanceof List)) break block7;
                List list = (List)value;
                packer.packListHeader(list.size());
                for (Object o : list) {
                    this.doTheThing(packer, o);
                }
                break block3;
            }
            if (!(value instanceof Map)) break block3;
            Map map = (Map)value;
            packer.packMapHeader(map.size());
            for (Map.Entry o : map.entrySet()) {
                this.doTheThing(packer, o.getKey());
                this.doTheThing(packer, o.getValue());
            }
        }
    }

    private static class Machine {
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();
        private final WritableByteChannel writable = Channels.newChannel(this.output);
        private final PackStream.Packer packer;

        Machine() {
            this.packer = new PackStream.Packer((PackOutput)new BufferedChannelOutput(this.writable));
        }

        Machine(int bufferSize) {
            this.packer = new PackStream.Packer((PackOutput)new BufferedChannelOutput(this.writable, bufferSize));
        }

        public void reset() {
            this.output.reset();
        }

        public byte[] output() {
            return this.output.toByteArray();
        }

        public PackStream.Packer packer() {
            return this.packer;
        }
    }
}

