/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.encoder;

import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.v1.messaging.encoder.FailureMessageEncoder;
import org.neo4j.bolt.v1.messaging.response.FailureMessage;
import org.neo4j.bolt.v1.messaging.response.FatalFailureMessage;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;

class FailureMessageEncoderTest {
    FailureMessageEncoderTest() {
    }

    @Test
    void shouldEncodeFailureMessage() throws Throwable {
        Neo4jPack.Packer packer = (Neo4jPack.Packer)Mockito.mock(Neo4jPack.Packer.class);
        Log log = (Log)Mockito.mock(Log.class);
        FailureMessageEncoder encoder = new FailureMessageEncoder(log);
        QueryResult.Record value = (QueryResult.Record)Mockito.mock(QueryResult.Record.class);
        Mockito.when((Object)value.fields()).thenReturn((Object)new AnyValue[0]);
        encoder.encode(packer, new FailureMessage((Status)Status.General.UnknownError, "I am an error message"));
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.never())).debug(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.any(FailureMessage.class)});
        ((Neo4jPack.Packer)Mockito.verify((Object)packer)).packStructHeader(ArgumentMatchers.anyInt(), ArgumentMatchers.eq((byte)127));
        ((Neo4jPack.Packer)Mockito.verify((Object)packer)).packMapHeader(2);
        ((Neo4jPack.Packer)Mockito.verify((Object)packer)).pack("code");
        ((Neo4jPack.Packer)Mockito.verify((Object)packer)).pack("message");
    }

    @Test
    void shouldLogErrorIfIsFatalError() throws Throwable {
        Neo4jPack.Packer packer = (Neo4jPack.Packer)Mockito.mock(Neo4jPack.Packer.class);
        Log log = (Log)Mockito.mock(Log.class);
        FailureMessageEncoder encoder = new FailureMessageEncoder(log);
        QueryResult.Record value = (QueryResult.Record)Mockito.mock(QueryResult.Record.class);
        Mockito.when((Object)value.fields()).thenReturn((Object)new AnyValue[0]);
        FatalFailureMessage message = new FatalFailureMessage((Status)Status.General.UnknownError, "I am an error message");
        encoder.encode(packer, (FailureMessage)message);
        ((Log)Mockito.verify((Object)log)).debug("Encoding a fatal failure message to send. Message: %s", new Object[]{message});
    }
}

