/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.decoder;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.decoder.RunMessageDecoder;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackedInputArray;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;

class RunMessageDecoderTest {
    private final BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
    private final RequestMessageDecoder decoder = new RunMessageDecoder(this.responseHandler);

    RunMessageDecoderTest() {
    }

    @Test
    void shouldReturnCorrectSignature() {
        Assertions.assertEquals((int)16, (int)this.decoder.signature());
    }

    @Test
    void shouldReturnConnectResponseHandler() {
        Assertions.assertEquals((Object)this.responseHandler, (Object)this.decoder.responseHandler());
    }

    @Test
    void shouldDecodeAckFailure() throws Exception {
        Neo4jPackV1 neo4jPack = new Neo4jPackV1();
        RunMessage originalMessage = new RunMessage("UNWIND range(1, 10) AS x RETURN x, $y", VirtualValues.map((String[])new String[]{"y"}, (AnyValue[])new AnyValue[]{Values.longValue((long)42L)}));
        PackedInputArray innput = new PackedInputArray(MessageMatchers.serialize((Neo4jPack)neo4jPack, new RequestMessage[]{originalMessage}));
        Neo4jPack.Unpacker unpacker = neo4jPack.newUnpacker((PackInput)innput);
        unpacker.unpackStructHeader();
        unpacker.unpackStructSignature();
        RequestMessage deserializedMessage = this.decoder.decode(unpacker);
        Assertions.assertEquals((Object)originalMessage, (Object)deserializedMessage);
    }
}

