/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.decoder;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.v1.messaging.decoder.ResetMessageDecoder;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;

class ResetMessageDecoderTest {
    private final BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
    private final BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
    private final RequestMessageDecoder decoder = new ResetMessageDecoder(this.connection, this.responseHandler);

    ResetMessageDecoderTest() {
    }

    @Test
    void shouldReturnCorrectSignature() {
        Assertions.assertEquals((int)15, (int)this.decoder.signature());
    }

    @Test
    void shouldReturnConnectResponseHandler() {
        Assertions.assertEquals((Object)this.responseHandler, (Object)this.decoder.responseHandler());
    }

    @Test
    void shouldDecodeAckFailure() throws Exception {
        RequestMessage message = this.decoder.decode((Neo4jPack.Unpacker)Mockito.mock(Neo4jPack.Unpacker.class));
        Assertions.assertEquals((Object)ResetMessage.INSTANCE, (Object)message);
        ((BoltConnection)Mockito.verify((Object)this.connection)).interrupt();
    }
}

