/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.decoder;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.bolt.v1.messaging.decoder.PrimitiveOnlyValueWriter;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

class PrimitiveOnlyValueWriterTest {
    PrimitiveOnlyValueWriterTest() {
    }

    @Test
    void shouldConvertStringValueToString() {
        PrimitiveOnlyValueWriter writer = new PrimitiveOnlyValueWriter();
        TextValue value = Values.stringValue((String)"Hello");
        Assertions.assertEquals((Object)"Hello", (Object)writer.valueAsObject((AnyValue)value));
    }

    @Test
    void shouldConvertLongValueToLong() {
        PrimitiveOnlyValueWriter writer = new PrimitiveOnlyValueWriter();
        LongValue value = Values.longValue((long)42L);
        Assertions.assertEquals((Object)42L, (Object)writer.valueAsObject((AnyValue)value));
    }

    @Test
    void shouldConvertMultipleValues() {
        PrimitiveOnlyValueWriter writer = new PrimitiveOnlyValueWriter();
        TextValue value1 = Values.stringValue((String)"Hello");
        TextValue value2 = Values.stringValue((String)" ");
        TextValue value3 = Values.stringValue((String)"World!");
        LongValue value4 = Values.longValue((long)42L);
        Assertions.assertEquals((Object)"Hello", (Object)writer.valueAsObject((AnyValue)value1));
        Assertions.assertEquals((Object)" ", (Object)writer.valueAsObject((AnyValue)value2));
        Assertions.assertEquals((Object)"World!", (Object)writer.valueAsObject((AnyValue)value3));
        Assertions.assertEquals((Object)42L, (Object)writer.valueAsObject((AnyValue)value4));
    }

    @ParameterizedTest
    @MethodSource(value={"unsupportedValues"})
    void shouldFailToWriteComplexValue(AnyValue value) {
        PrimitiveOnlyValueWriter writer = new PrimitiveOnlyValueWriter();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> writer.valueAsObject(value));
    }

    private static Stream<AnyValue> unsupportedValues() {
        return Stream.of(VirtualValues.nodeValue((long)42L, (TextArray)Values.stringArray((String[])new String[]{"Person"}), (MapValue)VirtualValues.EMPTY_MAP), PrimitiveOnlyValueWriterTest.newRelationshipValue(), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[2]), Values.byteArray((byte[])new byte[]{1, 2, 3}), Values.of((Object)Duration.ofHours(1L)), Values.of((Object)LocalDate.now()), Values.of((Object)LocalTime.now()), Values.of((Object)OffsetTime.now()), Values.of((Object)LocalDateTime.now()), Values.of((Object)ZonedDateTime.now()));
    }

    private static RelationshipValue newRelationshipValue() {
        NodeValue startNode = VirtualValues.nodeValue((long)24L, (TextArray)Values.stringArray((String[])new String[]{"Person"}), (MapValue)VirtualValues.EMPTY_MAP);
        NodeValue endNode = VirtualValues.nodeValue((long)42L, (TextArray)Values.stringArray((String[])new String[]{"Person"}), (MapValue)VirtualValues.EMPTY_MAP);
        return VirtualValues.relationshipValue((long)42L, (NodeValue)startNode, (NodeValue)endNode, (TextValue)Values.stringValue((String)"KNOWS"), (MapValue)VirtualValues.EMPTY_MAP);
    }
}

