/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging.decoder;

import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.security.auth.AuthTokenDecoderTest;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.decoder.InitMessageDecoder;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackedInputArray;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.AuthTokenUtil;

class InitMessageDecoderTest
extends AuthTokenDecoderTest {
    private final BoltResponseHandler responseHandler = (BoltResponseHandler)Mockito.mock(BoltResponseHandler.class);
    private final RequestMessageDecoder decoder = new InitMessageDecoder(this.responseHandler);

    InitMessageDecoderTest() {
    }

    @Test
    void shouldReturnCorrectSignature() {
        Assertions.assertEquals((int)1, (int)this.decoder.signature());
    }

    @Test
    void shouldReturnConnectResponseHandler() {
        Assertions.assertEquals((Object)this.responseHandler, (Object)this.decoder.responseHandler());
    }

    @Test
    void shouldDecodeAckFailure() throws Exception {
        Neo4jPackV1 neo4jPack = new Neo4jPackV1();
        InitMessage originalMessage = new InitMessage("My Driver", MapUtil.map((Object[])new Object[]{"user", "neo4j", "password", "secret"}));
        PackedInputArray innput = new PackedInputArray(MessageMatchers.serialize((Neo4jPack)neo4jPack, new RequestMessage[]{originalMessage}));
        Neo4jPack.Unpacker unpacker = neo4jPack.newUnpacker((PackInput)innput);
        unpacker.unpackStructHeader();
        unpacker.unpackStructSignature();
        RequestMessage deserializedMessage = this.decoder.decode(unpacker);
        Assertions.assertEquals((Object)originalMessage, (Object)deserializedMessage);
    }

    @Override
    protected void testShouldDecodeAuthToken(Map<String, Object> authToken) throws Exception {
        Neo4jPackV1 neo4jPack = new Neo4jPackV1();
        InitMessage originalMessage = new InitMessage("My Driver", authToken);
        PackedInputArray innput = new PackedInputArray(MessageMatchers.serialize((Neo4jPack)neo4jPack, new RequestMessage[]{originalMessage}));
        Neo4jPack.Unpacker unpacker = neo4jPack.newUnpacker((PackInput)innput);
        unpacker.unpackStructHeader();
        unpacker.unpackStructSignature();
        RequestMessage deserializedMessage = this.decoder.decode(unpacker);
        InitMessageDecoderTest.assertInitMessageMatches(originalMessage, deserializedMessage);
    }

    @Override
    protected void testShouldFailToDecodeAuthToken(Map<String, Object> authToken, String expectedErrorMessage) throws Exception {
        Neo4jPackV1 neo4jPack = new Neo4jPackV1();
        InitMessage originalMessage = new InitMessage("My Driver", authToken);
        PackedInputArray innput = new PackedInputArray(MessageMatchers.serialize((Neo4jPack)neo4jPack, new RequestMessage[]{originalMessage}));
        Neo4jPack.Unpacker unpacker = neo4jPack.newUnpacker((PackInput)innput);
        unpacker.unpackStructHeader();
        unpacker.unpackStructSignature();
        try {
            this.decoder.decode(unpacker);
            Assertions.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertEquals((Object)e.getMessage(), (Object)expectedErrorMessage);
        }
    }

    private static void assertInitMessageMatches(InitMessage expected, RequestMessage actual) {
        Assertions.assertEquals((Object)expected.userAgent(), (Object)((InitMessage)actual).userAgent());
        AuthTokenUtil.assertAuthTokenMatches((Map)expected.authToken(), (Map)((InitMessage)actual).authToken());
    }
}

