/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.ResponseMessage;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageRecorder;
import org.neo4j.bolt.v1.messaging.ResultHandler;
import org.neo4j.bolt.v1.messaging.response.RecordMessage;
import org.neo4j.bolt.v1.messaging.response.SuccessMessage;
import org.neo4j.bolt.v1.runtime.spi.ImmutableRecord;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

class ResultHandlerTest {
    ResultHandlerTest() {
    }

    @Test
    void shouldPullTheResult() throws Exception {
        BoltResponseMessageRecorder messageWriter = new BoltResponseMessageRecorder();
        ResultHandler handler = new ResultHandler((BoltResponseMessageWriter)messageWriter, (BoltConnection)Mockito.mock(BoltConnection.class), (Log)NullLog.getInstance());
        ImmutableRecord record1 = new ImmutableRecord((AnyValue[])Values.values((Object[])new Object[]{"a", "b", "c"}));
        ImmutableRecord record2 = new ImmutableRecord((AnyValue[])Values.values((Object[])new Object[]{"1", "2", "3"}));
        TestBoltResult result = new TestBoltResult(new QueryResult.Record[]{record1, record2});
        handler.onRecords((BoltResult)result, true);
        handler.onFinish();
        List<ResponseMessage> messages = messageWriter.asList();
        MatcherAssert.assertThat((Object)messages.size(), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)messages.get(0), (Matcher)Matchers.equalTo((Object)new RecordMessage((QueryResult.Record)record1)));
        MatcherAssert.assertThat((Object)messages.get(1), (Matcher)Matchers.equalTo((Object)new RecordMessage((QueryResult.Record)record2)));
        MatcherAssert.assertThat((Object)messages.get(2), (Matcher)Matchers.instanceOf(SuccessMessage.class));
    }

    @Test
    void shouldDiscardTheResult() throws Exception {
        BoltResponseMessageRecorder messageWriter = new BoltResponseMessageRecorder();
        ResultHandler handler = new ResultHandler((BoltResponseMessageWriter)messageWriter, (BoltConnection)Mockito.mock(BoltConnection.class), (Log)NullLog.getInstance());
        ImmutableRecord record1 = new ImmutableRecord((AnyValue[])Values.values((Object[])new Object[]{"a", "b", "c"}));
        ImmutableRecord record2 = new ImmutableRecord((AnyValue[])Values.values((Object[])new Object[]{"1", "2", "3"}));
        TestBoltResult result = new TestBoltResult(new QueryResult.Record[]{record1, record2});
        handler.onRecords((BoltResult)result, false);
        handler.onFinish();
        List<ResponseMessage> messages = messageWriter.asList();
        MatcherAssert.assertThat((Object)messages.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)messages.get(0), (Matcher)Matchers.instanceOf(SuccessMessage.class));
    }

    private static class TestBoltResult
    implements BoltResult {
        private final QueryResult.Record[] records;

        private TestBoltResult(QueryResult.Record ... records) {
            this.records = records;
        }

        public String[] fieldNames() {
            throw new UnsupportedOperationException();
        }

        public void accept(BoltResult.Visitor visitor) throws Exception {
            for (QueryResult.Record record : this.records) {
                visitor.visit(record);
            }
        }

        public void close() {
        }

        public String toString() {
            return "TestBoltResult{records=" + Arrays.toString(this.records) + '}';
        }
    }
}

