/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.ResponseMessage;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.Neo4jError;
import org.neo4j.bolt.v1.messaging.MessageProcessingHandler;
import org.neo4j.bolt.v1.messaging.response.FailureMessage;
import org.neo4j.bolt.v1.messaging.response.SuccessMessage;
import org.neo4j.bolt.v1.packstream.PackOutputClosedException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.test.matchers.CommonMatchers;

public class MessageProcessingHandlerTest {
    @Test
    public void shouldCallHaltOnUnexpectedFailures() throws Exception {
        BoltResponseMessageWriter msgWriter = MessageProcessingHandlerTest.newResponseHandlerMock();
        ((BoltResponseMessageWriter)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Something went horribly wrong")}).when((Object)msgWriter)).write((ResponseMessage)ArgumentMatchers.any(SuccessMessage.class));
        BoltConnection connection = (BoltConnection)Mockito.mock(BoltConnection.class);
        MessageProcessingHandler handler = new MessageProcessingHandler(msgWriter, connection, (Log)Mockito.mock(Log.class));
        handler.onFinish();
        ((BoltConnection)Mockito.verify((Object)connection)).stop();
    }

    @Test
    public void shouldLogOriginalErrorWhenOutputIsClosed() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfOriginalErrorWhenOutputIsClosed(Neo4jError.from((Throwable)new RuntimeException("Non-fatal error")));
    }

    @Test
    public void shouldLogOriginalFatalErrorWhenOutputIsClosed() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfOriginalErrorWhenOutputIsClosed(Neo4jError.fatalFrom((Throwable)new RuntimeException("Fatal error")));
    }

    @Test
    public void shouldLogWriteErrorAndOriginalErrorWhenUnknownFailure() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfWriteErrorAndOriginalErrorWhenUnknownFailure(Neo4jError.from((Throwable)new RuntimeException("Non-fatal error")));
    }

    @Test
    public void shouldLogWriteErrorAndOriginalFatalErrorWhenUnknownFailure() throws Exception {
        MessageProcessingHandlerTest.testLoggingOfWriteErrorAndOriginalErrorWhenUnknownFailure(Neo4jError.fatalFrom((Throwable)new RuntimeException("Fatal error")));
    }

    @Test
    public void shouldLogShortWarningOnClientDisconnectMidwayThroughQuery() throws Exception {
        PackOutputClosedException outputClosed = new PackOutputClosedException("Output closed", "<client>");
        Neo4jError txTerminated = Neo4jError.from((Throwable)new TransactionTerminatedException((Status)Status.Transaction.Terminated));
        AssertableLogProvider logProvider = MessageProcessingHandlerTest.emulateFailureWritingError(txTerminated, outputClosed);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((String)"Test").warn(Matchers.equalTo((Object)"Client %s disconnected while query was running. Session has been cleaned up. This can be caused by temporary network problems, but if you see this often, ensure your applications are properly waiting for operations to complete before exiting."), new Object[]{Matchers.equalTo((Object)"<client>")})});
    }

    private static void testLoggingOfOriginalErrorWhenOutputIsClosed(Neo4jError original) throws Exception {
        PackOutputClosedException outputClosed = new PackOutputClosedException("Output closed", "<client>");
        AssertableLogProvider logProvider = MessageProcessingHandlerTest.emulateFailureWritingError(original, outputClosed);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((String)"Test").warn(Matchers.startsWith((String)"Unable to send error back to the client"), Matchers.equalTo((Object)original.cause()))});
    }

    private static void testLoggingOfWriteErrorAndOriginalErrorWhenUnknownFailure(Neo4jError original) throws Exception {
        RuntimeException outputError = new RuntimeException("Output failed");
        AssertableLogProvider logProvider = MessageProcessingHandlerTest.emulateFailureWritingError(original, outputError);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog((String)"Test").error(Matchers.startsWith((String)"Unable to send error back to the client"), (Matcher)Matchers.both((Matcher)Matchers.equalTo((Object)outputError)).and(CommonMatchers.hasSuppressed((Throwable[])new Throwable[]{original.cause()})))});
    }

    private static AssertableLogProvider emulateFailureWritingError(Neo4jError error, Throwable errorDuringWrite) throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        BoltResponseMessageWriter responseHandler = MessageProcessingHandlerTest.newResponseHandlerMock(error.isFatal(), errorDuringWrite);
        MessageProcessingHandler handler = new MessageProcessingHandler(responseHandler, (BoltConnection)Mockito.mock(BoltConnection.class), logProvider.getLog("Test"));
        handler.markFailed(error);
        handler.onFinish();
        return logProvider;
    }

    private static BoltResponseMessageWriter newResponseHandlerMock(boolean fatalError, Throwable error) throws Exception {
        BoltResponseMessageWriter handler = MessageProcessingHandlerTest.newResponseHandlerMock();
        ((BoltResponseMessageWriter)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)handler)).write((ResponseMessage)ArgumentMatchers.any(FailureMessage.class));
        return handler;
    }

    private static BoltResponseMessageWriter newResponseHandlerMock() {
        return (BoltResponseMessageWriter)Mockito.mock(BoltResponseMessageWriter.class);
    }
}

