/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import io.netty.channel.Channel;
import java.time.Clock;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.MutableConnectionState;
import org.neo4j.bolt.v1.messaging.BoltStateMachineV1Context;

class BoltStateMachineV1ContextTest {
    BoltStateMachineV1ContextTest() {
    }

    @Test
    void shouldHandleFailure() throws BoltConnectionFatality {
        BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        BoltStateMachineV1Context context = BoltStateMachineV1ContextTest.newContext(machine, (BoltStateMachineSPI)Mockito.mock(BoltStateMachineSPI.class));
        RuntimeException cause = new RuntimeException();
        context.handleFailure((Throwable)cause, true);
        ((BoltStateMachine)Mockito.verify((Object)machine)).handleFailure((Throwable)cause, true);
    }

    @Test
    void shouldResetMachine() throws BoltConnectionFatality {
        BoltStateMachine machine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        BoltStateMachineV1Context context = BoltStateMachineV1ContextTest.newContext(machine, (BoltStateMachineSPI)Mockito.mock(BoltStateMachineSPI.class));
        context.resetMachine();
        ((BoltStateMachine)Mockito.verify((Object)machine)).reset();
    }

    private static BoltStateMachineV1Context newContext(BoltStateMachine machine, BoltStateMachineSPI boltSPI) {
        BoltChannel boltChannel = new BoltChannel("bolt-1", "bolt", (Channel)Mockito.mock(Channel.class));
        return new BoltStateMachineV1Context(machine, boltChannel, boltSPI, new MutableConnectionState(), Clock.systemUTC());
    }
}

