/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.ResponseMessage;
import org.neo4j.bolt.v1.messaging.BoltResponseMessage;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageWriterV1;
import org.neo4j.bolt.v1.messaging.response.FailureMessage;
import org.neo4j.bolt.v1.messaging.response.IgnoredMessage;
import org.neo4j.bolt.v1.messaging.response.RecordMessage;
import org.neo4j.bolt.v1.messaging.response.SuccessMessage;
import org.neo4j.bolt.v1.packstream.PackOutput;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class BoltResponseMessageWriterV1Test {
    @Test
    public void shouldWriteRecordMessage() throws Exception {
        PackOutput output = (PackOutput)Mockito.mock(PackOutput.class);
        Neo4jPack.Packer packer = (Neo4jPack.Packer)Mockito.mock(Neo4jPack.Packer.class);
        BoltResponseMessageWriterV1 writer = BoltResponseMessageWriterV1Test.newWriter(output, packer);
        writer.write((ResponseMessage)new RecordMessage(() -> new AnyValue[]{Values.longValue((long)42L), Values.stringValue((String)"42")}));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{output, packer});
        ((PackOutput)inOrder.verify((Object)output)).beginMessage();
        ((Neo4jPack.Packer)inOrder.verify((Object)packer)).pack((AnyValue)Values.longValue((long)42L));
        ((Neo4jPack.Packer)inOrder.verify((Object)packer)).pack((AnyValue)Values.stringValue((String)"42"));
        ((PackOutput)inOrder.verify((Object)output)).messageSucceeded();
    }

    @Test
    public void shouldWriteSuccessMessage() throws Exception {
        PackOutput output = (PackOutput)Mockito.mock(PackOutput.class);
        Neo4jPack.Packer packer = (Neo4jPack.Packer)Mockito.mock(Neo4jPack.Packer.class);
        BoltResponseMessageWriterV1 writer = BoltResponseMessageWriterV1Test.newWriter(output, packer);
        MapValue metadata = VirtualValues.map((String[])new String[]{"a", "b", "c"}, (AnyValue[])new AnyValue[]{Values.intValue((int)1), Values.stringValue((String)"2"), DateValue.date((int)2010, (int)2, (int)2)});
        writer.write((ResponseMessage)new SuccessMessage(metadata));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{output, packer});
        ((PackOutput)inOrder.verify((Object)output)).beginMessage();
        ((Neo4jPack.Packer)inOrder.verify((Object)packer)).pack((AnyValue)metadata);
        ((PackOutput)inOrder.verify((Object)output)).messageSucceeded();
    }

    @Test
    public void shouldWriteFailureMessage() throws Exception {
        PackOutput output = (PackOutput)Mockito.mock(PackOutput.class);
        Neo4jPack.Packer packer = (Neo4jPack.Packer)Mockito.mock(Neo4jPack.Packer.class);
        BoltResponseMessageWriterV1 writer = BoltResponseMessageWriterV1Test.newWriter(output, packer);
        Status.Transaction errorStatus = Status.Transaction.DeadlockDetected;
        String errorMessage = "Hi Deadlock!";
        writer.write((ResponseMessage)new FailureMessage((Status)errorStatus, errorMessage));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{output, packer});
        ((PackOutput)inOrder.verify((Object)output)).beginMessage();
        ((Neo4jPack.Packer)inOrder.verify((Object)packer)).pack(errorStatus.code().serialize());
        ((Neo4jPack.Packer)inOrder.verify((Object)packer)).pack(errorMessage);
        ((PackOutput)inOrder.verify((Object)output)).messageSucceeded();
    }

    @Test
    public void shouldWriteIgnoredMessage() throws Exception {
        PackOutput output = (PackOutput)Mockito.mock(PackOutput.class);
        Neo4jPack.Packer packer = (Neo4jPack.Packer)Mockito.mock(Neo4jPack.Packer.class);
        BoltResponseMessageWriterV1 writer = BoltResponseMessageWriterV1Test.newWriter(output, packer);
        writer.write((ResponseMessage)IgnoredMessage.IGNORED_MESSAGE);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{output, packer});
        ((PackOutput)inOrder.verify((Object)output)).beginMessage();
        ((Neo4jPack.Packer)inOrder.verify((Object)packer)).packStructHeader(0, BoltResponseMessage.IGNORED.signature());
        ((PackOutput)inOrder.verify((Object)output)).messageSucceeded();
    }

    @Test
    public void shouldFlush() throws Exception {
        PackOutput output = (PackOutput)Mockito.mock(PackOutput.class);
        Neo4jPack.Packer packer = (Neo4jPack.Packer)Mockito.mock(Neo4jPack.Packer.class);
        BoltResponseMessageWriterV1 writer = BoltResponseMessageWriterV1Test.newWriter(output, packer);
        writer.flush();
        ((Neo4jPack.Packer)Mockito.verify((Object)packer)).flush();
    }

    @Test
    public void shouldNotifyOutputAboutFailedRecordMessage() throws Exception {
        PackOutput output = (PackOutput)Mockito.mock(PackOutput.class);
        Neo4jPack.Packer packer = (Neo4jPack.Packer)Mockito.mock(Neo4jPack.Packer.class);
        IOException error = new IOException("Unable to pack 42");
        ((Neo4jPack.Packer)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)packer)).pack((AnyValue)Values.longValue((long)42L));
        BoltResponseMessageWriterV1 writer = BoltResponseMessageWriterV1Test.newWriter(output, packer);
        try {
            writer.write((ResponseMessage)new RecordMessage(() -> new AnyValue[]{Values.stringValue((String)"42"), Values.longValue((long)42L)}));
            Assert.fail((String)"Exception expected");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)error, (Object)e);
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{output, packer});
        ((PackOutput)inOrder.verify((Object)output)).beginMessage();
        ((Neo4jPack.Packer)inOrder.verify((Object)packer)).pack((AnyValue)Values.stringValue((String)"42"));
        ((Neo4jPack.Packer)inOrder.verify((Object)packer)).pack((AnyValue)Values.longValue((long)42L));
        ((PackOutput)inOrder.verify((Object)output)).messageFailed();
    }

    @Test
    public void shouldNotNotifyOutputWhenOutputItselfFails() throws Exception {
        PackOutput output = (PackOutput)Mockito.mock(PackOutput.class);
        Neo4jPack.Packer packer = (Neo4jPack.Packer)Mockito.mock(Neo4jPack.Packer.class);
        IOException error = new IOException("Unable to flush");
        ((PackOutput)Mockito.doThrow((Throwable[])new Throwable[]{error}).when((Object)output)).messageSucceeded();
        BoltResponseMessageWriterV1 writer = BoltResponseMessageWriterV1Test.newWriter(output, packer);
        try {
            writer.write((ResponseMessage)new RecordMessage(() -> new AnyValue[]{Values.longValue((long)1L), Values.longValue((long)2L)}));
            Assert.fail((String)"Exception expected");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)error, (Object)e);
        }
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{output, packer});
        ((PackOutput)inOrder.verify((Object)output)).beginMessage();
        ((Neo4jPack.Packer)inOrder.verify((Object)packer)).pack((AnyValue)Values.longValue((long)1L));
        ((Neo4jPack.Packer)inOrder.verify((Object)packer)).pack((AnyValue)Values.longValue((long)2L));
        ((PackOutput)inOrder.verify((Object)output)).messageSucceeded();
        ((PackOutput)Mockito.verify((Object)output, (VerificationMode)Mockito.never())).messageFailed();
    }

    private static BoltResponseMessageWriterV1 newWriter(PackOutput output, Neo4jPack.Packer packer) {
        return new BoltResponseMessageWriterV1(out -> packer, output, (LogService)NullLogService.getInstance());
    }
}

