/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v3.messaging.request.GoodbyeMessage;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;

public class BoltRequestMessageWriter {
    protected final Neo4jPack.Packer packer;

    public BoltRequestMessageWriter(Neo4jPack.Packer packer) {
        this.packer = packer;
    }

    public BoltRequestMessageWriter write(RequestMessage message) throws IOException {
        if (message instanceof InitMessage) {
            this.writeInit((InitMessage)message);
        } else if (message instanceof AckFailureMessage) {
            this.writeAckFailure();
        } else if (message instanceof ResetMessage) {
            this.writeReset();
        } else if (message instanceof RunMessage) {
            this.writeRun((RunMessage)message);
        } else if (message instanceof DiscardAllMessage) {
            this.writeDiscardAll();
        } else if (message instanceof PullAllMessage) {
            this.writePullAll();
        } else if (message instanceof GoodbyeMessage) {
            this.writeGoodbye();
        } else {
            throw new IllegalArgumentException("Unknown message: " + message);
        }
        return this;
    }

    private void writeGoodbye() {
        try {
            this.packer.packStructHeader(0, (byte)2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeInit(InitMessage message) {
        try {
            this.packer.packStructHeader(2, (byte)1);
            this.packer.pack(message.userAgent());
            this.packer.pack((AnyValue)ValueUtils.asMapValue((Map)message.authToken()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeAckFailure() {
        try {
            this.packer.packStructHeader(0, (byte)14);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeReset() {
        try {
            this.packer.packStructHeader(0, (byte)15);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeRun(RunMessage message) {
        try {
            this.packer.packStructHeader(2, (byte)16);
            this.packer.pack(message.statement());
            this.packer.pack((AnyValue)message.params());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeDiscardAll() {
        try {
            this.packer.packStructHeader(0, (byte)47);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writePullAll() {
        try {
            this.packer.packStructHeader(0, (byte)63);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void flush() {
        try {
            this.packer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

