/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.messaging.Neo4jPack;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.SynchronousBoltConnection;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageReaderV1;
import org.neo4j.bolt.v1.messaging.Neo4jPackV1;
import org.neo4j.bolt.v1.messaging.request.AckFailureMessage;
import org.neo4j.bolt.v1.messaging.request.DiscardAllMessage;
import org.neo4j.bolt.v1.messaging.request.InitMessage;
import org.neo4j.bolt.v1.messaging.request.PullAllMessage;
import org.neo4j.bolt.v1.messaging.request.ResetMessage;
import org.neo4j.bolt.v1.messaging.request.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.packstream.PackInput;
import org.neo4j.bolt.v1.packstream.PackedInputArray;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;

public class BoltRequestMessageReaderV1Test {
    @Test
    void shouldDecodeInitMessage() throws Exception {
        BoltRequestMessageReaderV1Test.testMessageDecoding((RequestMessage)new InitMessage("My driver", MapUtil.map((Object[])new Object[]{"one", 1L, "two", 2L})));
    }

    @Test
    void shouldDecodeAckFailureMessage() throws Exception {
        BoltRequestMessageReaderV1Test.testMessageDecoding((RequestMessage)AckFailureMessage.INSTANCE);
    }

    @Test
    void shouldDecodeResetMessage() throws Exception {
        BoltRequestMessageReaderV1Test.testMessageDecoding((RequestMessage)ResetMessage.INSTANCE);
    }

    @Test
    void shouldDecodeRunMessage() throws Exception {
        BoltRequestMessageReaderV1Test.testMessageDecoding((RequestMessage)new RunMessage("RETURN $answer", VirtualValues.map((String[])new String[]{"answer"}, (AnyValue[])new AnyValue[]{Values.stringValue((String)"42")})));
    }

    @Test
    void shouldDecodeDiscardAllMessage() throws Exception {
        BoltRequestMessageReaderV1Test.testMessageDecoding((RequestMessage)DiscardAllMessage.INSTANCE);
    }

    @Test
    void shouldDecodePullAllMessage() throws Exception {
        BoltRequestMessageReaderV1Test.testMessageDecoding((RequestMessage)PullAllMessage.INSTANCE);
    }

    private static void testMessageDecoding(RequestMessage message) throws Exception {
        Neo4jPackV1 neo4jPack = new Neo4jPackV1();
        BoltStateMachine stateMachine = (BoltStateMachine)Mockito.mock(BoltStateMachine.class);
        BoltRequestMessageReader reader = BoltRequestMessageReaderV1Test.newReader(stateMachine);
        PackedInputArray innput = new PackedInputArray(MessageMatchers.serialize((Neo4jPack)neo4jPack, message));
        Neo4jPack.Unpacker unpacker = neo4jPack.newUnpacker((PackInput)innput);
        reader.read(unpacker);
        ((BoltStateMachine)Mockito.verify((Object)stateMachine)).process((RequestMessage)ArgumentMatchers.eq((Object)message), (BoltResponseHandler)ArgumentMatchers.any());
    }

    private static BoltRequestMessageReader newReader(BoltStateMachine stateMachine) {
        return new BoltRequestMessageReaderV1((BoltConnection)new SynchronousBoltConnection(stateMachine), (BoltResponseMessageWriter)Mockito.mock(BoltResponseMessageWriter.class), (LogService)NullLogService.getInstance());
    }
}

