/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1;

import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BoltStateMachine;
import org.neo4j.bolt.runtime.BoltStateMachineFactory;
import org.neo4j.bolt.transport.pipeline.ChunkDecoder;
import org.neo4j.bolt.transport.pipeline.HouseKeeper;
import org.neo4j.bolt.transport.pipeline.MessageAccumulator;
import org.neo4j.bolt.transport.pipeline.MessageDecoder;
import org.neo4j.bolt.v1.BoltProtocolV1;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;

public class BoltProtocolV1Test {
    private final EmbeddedChannel channel = new EmbeddedChannel();

    @After
    public void cleanup() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    public void shouldInstallChannelHandlersInCorrectOrder() throws Throwable {
        BoltChannel boltChannel = BoltProtocolV1Test.newBoltChannel((Channel)this.channel);
        BoltConnectionFactory connectionFactory = (BoltConnectionFactory)Mockito.mock(BoltConnectionFactory.class);
        Mockito.when((Object)connectionFactory.newConnection((BoltChannel)ArgumentMatchers.eq((Object)boltChannel), (BoltStateMachine)ArgumentMatchers.any())).thenReturn(Mockito.mock(BoltConnection.class));
        BoltProtocolV1 boltProtocol = new BoltProtocolV1(boltChannel, connectionFactory, (BoltStateMachineFactory)Mockito.mock(BoltStateMachineFactory.class), (LogService)NullLogService.getInstance());
        boltProtocol.install();
        Iterator handlers = this.channel.pipeline().iterator();
        Assert.assertThat(((Map.Entry)handlers.next()).getValue(), (Matcher)Matchers.instanceOf(ChunkDecoder.class));
        Assert.assertThat(((Map.Entry)handlers.next()).getValue(), (Matcher)Matchers.instanceOf(MessageAccumulator.class));
        Assert.assertThat(((Map.Entry)handlers.next()).getValue(), (Matcher)Matchers.instanceOf(MessageDecoder.class));
        Assert.assertThat(((Map.Entry)handlers.next()).getValue(), (Matcher)Matchers.instanceOf(HouseKeeper.class));
        Assert.assertFalse((boolean)handlers.hasNext());
    }

    private static BoltChannel newBoltChannel(Channel rawChannel) {
        return new BoltChannel("bolt-1", "bolt", rawChannel);
    }
}

